/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <contactinfos.h>

#include <gtk/gtk.h>
#include <libintl.h>

#include <glib/gtypes.h>
#include <glib/gerror.h>
#include <dbus/dbus-glib.h>

#include <client-contactinfos-dbus.h>
#include <dbus/marshall.h>

#include <config.h>

/* strlen needed from string.h */
#include <string.h>

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-font-selection-dialog.h>
#endif

#include <appdata.h>
#include <test/testui.h>

/*
void searchDummy_cb (GtkButton *widget, gpointer data) {
	GtkWidget *searchEntry = (GtkWidget *) data;
	GSList *list;
	GSList *souslist;
	GSList *start;
	GtkWidget *parent;
	gchar *chaine = NULL;
	gchar *souschaine = NULL;
	GtkWidget *dialog;
	gpointer backendData;
	guint requestedInfos = PHONE_NUMBER;
	parent = gtk_widget_get_toplevel(GTK_WIDGET(widget));
	initBackend(&backendData);
	gboolean ret = interface_dialog_new( GTK_WINDOW(parent), TRUE, TRUE, gtk_entry_get_text(GTK_ENTRY(searchEntry)), &list, backendData, requestedInfos);
	terminateBackend(backendData);
	
}

void callDbus_cb(GtkButton *widget, gpointer data) {
	AppData *appData = (AppData *) data;
	DBusGConnection *connection;
	GError *error;
	DBusGProxy *proxy;
	char **reponse;
	char **strs_p;
	
	gboolean ret;
	gchar *searchText;
	guint requestedInfos = appData->requestedInfos;
	gchar *res;
	
	g_type_init ();

	searchText = g_strdup(gtk_entry_get_text(GTK_ENTRY(appData->searchEntry)));

	res = g_strdup_printf("Search -%s-\nRequestedInfos %X\nMultipleSel %d\nShowGui %d\n", searchText, requestedInfos, appData->multipleSel, appData->showGui);
	gtk_text_buffer_set_text (appData->buffer, res, -1);
	g_free(res);
	
	error = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION,
			       &error);
	if (connection == NULL)
	{
		g_printerr ("Failed to open connection to bus: %s\n",
		  error->message);
		g_error_free (error);
		return;
	}

	/* Create a proxy object for the "bus driver" (name "org.freedesktop.DBus") */
/*
	proxy = dbus_g_proxy_new_for_name (connection,
				     CONTACTINFOS_DBUS_NAME,
				     CONTACTINFOS_DBUS_PATH,
				     CONTACTINFOS_DBUS_INTERFACE);


	error = NULL;
	ret = com_nokia_contactinfos_get_contact_infos (proxy, requestedInfos, searchText, appData->showGui, appData->multipleSel, &reponse, &error);
	g_object_unref (proxy);

	if (error) {
		res  = g_strdup_printf("Error\n  Code = %d\n  Message = %s\n", error->code, error->message);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);
		g_free(searchText);
		return;
	}

	res = g_strdup_printf("Ret = %d\n Resultats\n", ret);
	gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
	g_free(res);
	for (strs_p = reponse; *strs_p; strs_p++) {
		gtk_text_buffer_insert_at_cursor (appData->buffer, *strs_p, -1);
		gtk_text_buffer_insert_at_cursor (appData->buffer, "\n", -1);
	}
	g_strfreev (reponse);	
	
	g_free(searchText);
}

void reply_cb(DBusGProxy *proxy, char ** response, GError *error, gpointer data) {
	AppData *appData = (AppData *) data;
	
	char **strs_p;
	gchar *res;

	if (error) {
		res  = g_strdup_printf("Error\n  Code = %d\n  Message = %s\n", error->code, error->message);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);
		g_object_unref (proxy);
		return;
	}
	
	for (strs_p = response; *strs_p; strs_p++) {
		gtk_text_buffer_insert_at_cursor (appData->buffer, *strs_p, -1);
		gtk_text_buffer_insert_at_cursor (appData->buffer, "\n", -1);
	}
/*
	g_strfreev (response);	
*/
/*
	g_object_unref (proxy);

}

void callDbusAsync_cb(GtkButton *widget, gpointer data) {
	AppData *appData = (AppData *) data;
	DBusGConnection *connection;
	GError *error;
	DBusGProxy *proxy;
	DBusGProxyCall *call;
	
	gchar *searchText;
	guint requestedInfos = appData->requestedInfos;
	gchar *res;
	
	g_type_init ();

	searchText = g_strdup(gtk_entry_get_text(GTK_ENTRY(appData->searchEntry)));

	res = g_strdup_printf("Search -%s-\nRequestedInfos %X\nMultipleSel %d\nShowGui %d\n", searchText, requestedInfos, appData->multipleSel, appData->showGui);
	gtk_text_buffer_set_text (appData->buffer, res, -1);
	g_free(res);
	
	error = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION,
			       &error);
	if (connection == NULL)
	{
		g_printerr ("Failed to open connection to bus: %s\n",
		  error->message);
		g_error_free (error);
		return;
	}

	/* Create a proxy object for the "bus driver" (name "org.freedesktop.DBus") */
/*
	proxy = dbus_g_proxy_new_for_name (connection,
				     CONTACTINFOS_DBUS_NAME,
				     CONTACTINFOS_DBUS_PATH,
				     CONTACTINFOS_DBUS_INTERFACE);


	error = NULL;
	call = com_nokia_contactinfos_get_contact_infos_async (proxy, requestedInfos, searchText, appData->showGui, appData->multipleSel, (com_nokia_contactinfos_get_contact_infos_reply) reply_cb, (gpointer) appData);
	g_free(searchText);
}
*/
void resultFoundSignal_cb(DBusGProxy *proxy, GPtrArray * response, AppData *appData) {
	gchar *res;
	
	res = g_strdup_printf("resultFoundSignal_cb response=%p\n", response);
	gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
	g_free(res);

	dbus_g_proxy_disconnect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_CALLBACK(resultFoundSignal_cb), appData);

	g_object_unref (proxy);

}

void oneResultSignal_cb(DBusGProxy *proxy, gchar *name, gchar *company, guint typeInfo, gchar *type, gchar *value, guint elementId, guint valueId, gint retCode, AppData *appData) {
	gchar *res;
	
	if (retCode >= CI_NO_ERROR) {
		res = g_strdup_printf("oneResultSignal_cb name=%s eltId %d valueId %d\n", name, elementId, valueId);
		gtk_text_buffer_insert_at_cursor(appData->buffer, res, -1);
		g_free(res);
	}
	
	if (retCode < CI_NO_ERROR || (elementId == CI_LAST_ELEMENT_ID && valueId==CI_LAST_VALUE_ID)) {
		res = g_strdup_printf("endResultSignal_cb RetCode=%d \n", retCode);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);

		dbus_g_proxy_disconnect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
			G_CALLBACK(oneResultSignal_cb), appData);

		g_object_unref (proxy);

	}

}

void callDbusSignal_cb(GtkButton *widget, gpointer data) {
	AppData *appData = (AppData *) data;
	DBusGConnection *connection;
	GError *error;
	DBusGProxy *proxy;
	gboolean availability = FALSE;
	
	gchar *searchText;
	guint requestedInfos = appData->requestedInfos;
	gchar *res;
	guint upperLimit;
	
	g_type_init ();

	searchText = g_strdup(gtk_entry_get_text(GTK_ENTRY(appData->searchEntry)));
	upperLimit = (guint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(appData->limitEntry));

	res = g_strdup_printf("Search -%s-\nRequestedInfos %X\nMultipleSel %d\nShowGui %d\n", searchText, requestedInfos, appData->multipleSel, appData->showGui);
	gtk_text_buffer_set_text (appData->buffer, res, -1);
	g_free(res);
	
	error = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION,
			       &error);
	if (connection == NULL)
	{
		g_printerr ("Failed to open connection to bus: %s\n",
		  error->message);
		g_error_free (error);
		return;
	}

	/* Create a proxy object for the "bus driver" (name "org.freedesktop.DBus") */

	proxy = dbus_g_proxy_new_for_name (connection,
				     CONTACTINFOS_DBUS_NAME,
				     CONTACTINFOS_DBUS_PATH,
				     CONTACTINFOS_DBUS_INTERFACE);


	/* Connection to signal 
	Has DBus doesn't support structures and complex array yet
	We'll work it out via several signals
	And we have to add a final signal !
	*/
	dbus_g_object_register_marshaller(
		dbus_glib_marshal_contactinfos_VOID__STRING_STRING_UINT_STRING_STRING_UINT_UINT_INT,
		G_TYPE_NONE,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_UINT,
		G_TYPE_INT,
		G_TYPE_INVALID);

	dbus_g_proxy_add_signal(proxy,
		CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_UINT,
		G_TYPE_INT,
		G_TYPE_INVALID);

	dbus_g_proxy_connect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_CALLBACK(oneResultSignal_cb), appData, NULL);
	
/* Not supported by DBus yet
	dbus_g_object_register_marshaller(
		dbus_glib_marshal_contactinfos_VOID__BOXED_POINTER,
		G_TYPE_NONE,
		G_TYPE_BOXED,
		G_TYPE_POINTER,
		G_TYPE_INVALID);
	
	dbus_g_proxy_add_signal(proxy,
		CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_TYPE_BOXED,
		G_TYPE_POINTER,
		G_TYPE_INVALID);

	dbus_g_proxy_connect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_CALLBACK(resultFoundSignal_cb), appData, NULL);
*/

	/* Start DBus Call */
	error = NULL;
	com_nokia_contactinfos_get_contact_infos (
								proxy, 
								requestedInfos, 
								searchText, 
								appData->showGui, 
								appData->confirm, 
								appData->multipleSel, 
								upperLimit, 
								&availability, 
								&error);
	g_free(searchText);
	if (error) {
		res  = g_strdup_printf("Error\n  Code = %d\n  Message = %s\n", error->code, error->message);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);
	} else {
		if (availability) {
			res  = g_strdup_printf("callDbusSignal_cb No Error\nWaiting for an answer ...\n");
			gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
			g_free(res);
		} else {
			res  = g_strdup_printf("callDbusSignal_cb No Error\nForget it ...\n");
			gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
			g_free(res);
		}
	}
/*
	g_object_unref (proxy);
*/
}

void setRowChecked_cb(GtkCellRendererToggle *cell, gchar *path, gpointer data) {
	AppData *mainview = NULL;
	mainview = ( AppData * ) data;
	g_assert(mainview != NULL);

	GtkTreeIter iter;
	gboolean rowChecked;
	guint info;

	GtkTreeModel *model = GTK_TREE_MODEL(mainview->storeSearch);
	if ( !gtk_tree_model_get_iter_from_string(model, &iter, path) ) {
		return;
	}

	gtk_tree_model_get(model, &iter,
		CHECK_COLUMN, &rowChecked,
		INFO_COLUMN, &info,
		-1);

	rowChecked = !rowChecked;
	gtk_tree_store_set(GTK_TREE_STORE(mainview->storeSearch), &iter,
		   CHECK_COLUMN, rowChecked, -1);
	if (rowChecked) {
		mainview->requestedInfos |= info;
	} else {
		mainview->requestedInfos &= ~info;
	}
}

void setBoolean_cb(GtkToggleButton *checkBox, gboolean *boolValue) {
	*boolValue = gtk_toggle_button_get_active(checkBox);
}
