/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <ui/interface.h>

#define EXIT_TIMEOUT 5000 /* milliseconds */
#define EXIT_TIMEOUT_WHEN_DIALOG_OPENED 60000 /* milliseconds */

static GSource *exit_timer = NULL;

gboolean exit_cb(AppUIData *data) {
#ifdef DEBUG
	g_printf("exit_cb(AppUIData *data=%p)\n", data);
#endif
	g_printf("contactinfos running but no requests received.");
	/* close dialog if open which cannot happen ! */
	if (data && data->dialog) {
		gtk_widget_destroy (data->dialog);
	}
	/*close application */
	gtk_main_quit ();
	return FALSE;
}

void setExitTimer(AppUIData *data, gboolean dialog) {
#ifdef DEBUG
	g_printf("setExitTimer(AppUIData *data=%p)\n", data);
#endif
	if (exit_timer) {
		g_source_destroy(exit_timer);
	}
	if (dialog) {
		exit_timer = g_timeout_source_new(EXIT_TIMEOUT_WHEN_DIALOG_OPENED);
	} else {
		exit_timer = g_timeout_source_new(EXIT_TIMEOUT);
	}
	g_source_set_callback(exit_timer, (GSourceFunc) exit_cb, (gpointer) data, NULL);
	(void) g_source_attach(exit_timer, NULL);
}

void removeExitTimer(AppUIData *data) {
#ifdef DEBUG
	g_printf("removeExitTimer(AppUIData *data=%p)\n", data);
#endif
	if (exit_timer) {
		g_source_destroy(exit_timer);
		exit_timer = NULL;
	}
}
