/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef CONTACTS_EDS_H
#define CONTACTS_EDS_H

#define CONTACTINFOS_DBUS_ERROR  g_quark_from_static_string ("contactinfos-backend-gpe")

/* Field id for contact */
#define EDS_FIRST_NAME	5
#define EDS_LAST_NAME		6
#define EDS_NICKNAME		7
#define EDS_EMAIL			8
#define EDS_WEB			42
#define EDS_PHONE		110
/* 96 97 */

#define EDS_VCARD_TYPE_URL		"URL"
#define EDS_VCARD_TYPE_TEL			"TEL"
#define EDS_VCARD_TYPE_EMAIL		"EMAIL"

gboolean eds_open_pl (GError ** error);
gboolean eds_close_pl(GError **error);
gboolean eds_get_phone_list (const gchar *name, guint requestedInfos, GSList **listOut, GError ** error);

#endif
