/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>

#include <gtk/gtk.h>
#include <libintl.h>

/* strlen needed from string.h */
#include <string.h>

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-font-selection-dialog.h>
#endif

#include <contactinfos.h>
#include <test/testui.h>
#include <test/testcallback.h>


/* Creates and initialises a main_view */
AppData* interface_main_view_new( AppData *data ) {
	GtkWidget* table;
	GtkWidget *button;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkWidget *scrolled_window;
	GtkWidget *treeSearch;
	GtkTreeIter iter;
	GtkWidget *view;
	GtkWidget *checkBox;


	/* Store handle to hildon_window to app's data */
	data->window = HILDON_WINDOW(hildon_window_new());
	
	data->multipleSel = TRUE;
	data->showGui = TRUE;
	data->confirm = TRUE;
	
	data->storeSearch = gtk_tree_store_new (N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_UINT);
	/* remplissage */
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, TRUE, LABEL_COLUMN, "PHONE_NUMBER", INFO_COLUMN, CI_PHONE_NUMBER, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, TRUE, LABEL_COLUMN, "MOBILE_PHONE_NUMBER", INFO_COLUMN, CI_MOBILE_PHONE_NUMBER, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, TRUE, LABEL_COLUMN, "FAX_PHONE_NUMBER", INFO_COLUMN, CI_FAX_PHONE_NUMBER, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "FULL_ADDRESS", INFO_COLUMN, CI_FULL_ADDRESS, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "GPS_COORDINATE", INFO_COLUMN, CI_GPS_COORDINATE, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "CITY", INFO_COLUMN, CI_CITY, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "POST_CODE", INFO_COLUMN, CI_POST_CODE, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "ADDRESS", INFO_COLUMN, CI_ADDRESS, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "NAME", INFO_COLUMN, CI_NAME, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "COMPANY", INFO_COLUMN, CI_COMPANY, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "VALUE_TYPE", INFO_COLUMN, CI_VALUE_TYPE, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "EMAIL", INFO_COLUMN, CI_EMAIL, -1);
	gtk_tree_store_append(data->storeSearch, &iter, NULL);
	gtk_tree_store_set(data->storeSearch, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, "WEB", INFO_COLUMN, CI_WEB, -1);

	data->requestedInfos = CI_ALL_PHONE_NUMBER;

	/* Create all our necessary parts */
	/* la boite gnrale */
	table = gtk_table_new(9, 5, TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(table), 5);
	
	/* Add a field & 2 buttons */
	data->searchEntry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(data->searchEntry), "Fred");
	gtk_table_attach_defaults( GTK_TABLE(table), data->searchEntry, 0, 3, 0, 1);

	/* Buttons */
/*
	button = gtk_button_new_with_label ("Search");
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (callDbus_cb), data);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 0, 1);

	button = gtk_button_new_with_label ("Async.");
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (callDbusAsync_cb), data);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 0, 1);
*/

	button = gtk_button_new_with_label ("Search Signal");
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (callDbusSignal_cb), data);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 5, 0, 1);

	/* list de infos */
	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	
	treeSearch = gtk_tree_view_new_with_model (GTK_TREE_MODEL (data->storeSearch));
#if HILDON == 0
	g_object_set(G_OBJECT(treeSearch), "allow-checkbox-mode", FALSE, NULL);
	g_object_set(G_OBJECT(treeSearch), "force-list-kludge", TRUE, NULL);
#endif

	gtk_container_add(GTK_CONTAINER(scrolled_window), treeSearch);
	gtk_table_attach_defaults( GTK_TABLE(table), scrolled_window, 0, 3, 1, 6);

	renderer = gtk_cell_renderer_toggle_new ();
	g_signal_connect (renderer, "toggled", G_CALLBACK (setRowChecked_cb), data);
	column = gtk_tree_view_column_new_with_attributes (_("Check"), renderer, "active", CHECK_COLUMN, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeSearch), column);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Info", renderer, "text", LABEL_COLUMN, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeSearch), column);
	
	/* Setup the selection handler */
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeSearch)), GTK_SELECTION_SINGLE);

	gtk_tree_view_columns_autosize(GTK_TREE_VIEW(treeSearch));
	
	/* text retour */
	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	
	view = gtk_text_view_new ();
	data->buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));

	gtk_container_add(GTK_CONTAINER(scrolled_window), view);
	gtk_table_attach_defaults( GTK_TABLE(table), scrolled_window, 0, 5, 6, 9);
	
	/* Check boxes */
	checkBox = gtk_check_button_new_with_label ("MultiSelection");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkBox), data->multipleSel);
	g_signal_connect (checkBox, "toggled", G_CALLBACK (setBoolean_cb), &(data->multipleSel));
	gtk_table_attach_defaults( GTK_TABLE(table), checkBox, 3, 5, 1, 2);
	checkBox = gtk_check_button_new_with_label ("ShowGui");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkBox), data->showGui);
	g_signal_connect (checkBox, "toggled", G_CALLBACK (setBoolean_cb), &(data->showGui));
	gtk_table_attach_defaults( GTK_TABLE(table), checkBox, 3, 5, 2, 3);
	checkBox = gtk_check_button_new_with_label ("Confirm");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkBox), data->confirm);
	g_signal_connect (checkBox, "toggled", G_CALLBACK (setBoolean_cb), &(data->confirm));
	gtk_table_attach_defaults( GTK_TABLE(table), checkBox, 3, 5, 3, 4);

	data->limitEntry = gtk_spin_button_new_with_range(0.0, 10000.0, 10);
	gtk_table_attach_defaults( GTK_TABLE(table), data->limitEntry, 3, 5, 4, 5);

	/* Put GTK table to app's view */
	gtk_container_add( GTK_CONTAINER( data->window ), table );
	gtk_widget_show_all( GTK_WIDGET(table) );
	/* Focus on search Entry */
	gtk_widget_grab_focus( GTK_WIDGET(data->searchEntry ));

	/* Return with new mainview handle */
	return data;
}

/* clean up the allocated memory */
void interface_main_view_destroy( AppData *main ) {
	g_printf("destroyed !!!\n");
}

