#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Libraries
######################################################
import gobject, dbus, os, sys
gobject.threads_init()
from dbus.mainloop.glib import DBusGMainLoop
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

#Files
###########################################################################################
from Config import Config

#Classes
######################################################
class AutoUnlocker:
	def  __init__(self):
		self.Config = Config()
		self.bus = dbus.bus.BusConnection("unix:path=/var/run/dbus/system_bus_socket")
		self.object = self.bus.get_object('com.nokia.mce', '/com/nokia/mce/request')
		self.keyboardObject = self.bus.get_object('org.freedesktop.Hal', '/org/freedesktop/Hal/devices/platform_slide')
		self.interface = dbus.Interface(self.object, dbus_interface='com.nokia.mce.request')
 
	def start(self): #Check for events
		self.bus.add_signal_receiver(self.unlockEvent, path='/com/nokia/mce/signal', dbus_interface='com.nokia.mce.signal', signal_name='tklock_mode_ind')
		#self.bus.add_signal_receiver(self.powerEvent, path='/org/freedesktop/Hal/devices/computer_logicaldev_input', dbus_interface='org.freedesktop.Hal.Device', signal_name='Condition')
		self.bus.add_signal_receiver(self.keyboardEvent, path='/org/freedesktop/Hal/devices/platform_slide', dbus_interface='org.freedesktop.Hal.Device', signal_name='PropertyModified')
		self.bus.add_signal_receiver(self.slideEvent, path='/org/freedesktop/Hal/devices/platform_kb_lock', dbus_interface='org.freedesktop.Hal.Device', signal_name='PropertyModified')
		gobject.MainLoop().run()

	def unlockEvent(self, tklock=""):
		if self.interface.get_devicelock_mode() == "locked" and tklock == "unlocked":
			self.unlock()

	def keyboardEvent(self, ignore1="", ignore2=""):
		if self.interface.get_devicelock_mode() == "locked" and self.interface.get_tklock_mode() == "unlocked" and self.keyboardObject.GetProperty('button.state.value') == 0:
			self.unlock()

	def slideEvent(self, ignore1="", ignore2=""):
		if self.interface.get_devicelock_mode() == "locked" and self.interface.get_tklock_mode() == "unlocked":
			self.unlock()


	def unlock(self):
		ssid = os.popen("/sbin/iwgetid | awk -F'\"' '{print $2}'")
		ssid = ssid.readline()
		if ssid[0:-1] in self.Config.getTrustedNetworks():
			try: #TODO: Something smarter?
				self.interface.devlock_callback(dbus.Int32("2"), timeout = 0)
			except dbus.exceptions.DBusException:
				pass

#Run
######################################################
if __name__ == "__main__":
	#First fork
	try: 
		pid = os.fork() 
		if pid > 0:
			sys.exit(0) 
	except OSError, e: 
		sys.exit(1)
	#Enviroment
	os.chdir("/") 
	os.setsid() 
	os.umask(0)
	#Second fork 
	try: 
		pid = os.fork() 
		if pid > 0:
			sys.exit(0) 
	except OSError, e: 
		sys.exit(1)
	#Start 
	daemon = AutoUnlocker()
	daemon.start()
