/*
 *  connectnow home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef CONNECTNOW_HOME_PLUGIN_H
#define CONNECTNOW_HOME_PLUGIN_H

#include <glib-object.h>
#include <conic.h>
#include <hildon/hildon.h>
#include <libhildondesktop/libhildondesktop.h>

static const gchar* GENERAL_CONNECTED = "connectnow_general_connected";
static const gchar* GENERAL_DISCONNECTED = "connectnow_general_disconnected";


G_BEGIN_DECLS

typedef struct _ConnectNowHomePlugin ConnectNowHomePlugin;
typedef struct _ConnectNowHomePluginClass ConnectNowHomePluginClass;

#define CONNECT_NOW_HOME_PLUGIN_TYPE (connect_now_home_plugin_get_type())

#define CONNECT_NOW_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								 CONNECT_NOW_HOME_PLUGIN_TYPE, ConnectNowHomePlugin))

#define CONNECT_NOW_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                        CONNECT_NOW_HOME_PLUGIN_TYPE,  ConnectNowHomePluginClass))

#define CONNECT_NOW_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
								CONNECT_NOW_HOME_PLUGIN_TYPE))

#define CONNECT_NOW_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
									   CONNECT_NOW_HOME_PLUGIN_TYPE))


#define CONNECT_NOW_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
									   CONNECT_NOW_HOME_PLUGIN_TYPE, ConnectNowHomePluginClass))

struct _ConnectNowHomePlugin
{
  HDHomePluginItem hitem;
  gchar* connection_id;
  gchar* connection_name;
  gchar* current_connection_id;
  ConIcConnection* con;
  gint this_connection_state;
  gboolean connect_now;

  gchar* iD;
  gchar* connectedImageName;
  gchar* disconnectedImageName;
  GdkPixbuf* connectedImage;
  GdkPixbuf* disconnectedImage;
  guint widget_size;
  gboolean hide_connection_name;

  GdkPixbuf* fallback_connectedImage;
  GdkPixbuf* fallback_disconnectedImage;
  guint on_connect_action;
  guint on_disconnect_action;
};

struct _ConnectNowHomePluginClass
{
  HDHomePluginItemClass parent_class;

};

GType connect_now_home_plugin_get_type(void);

G_END_DECLS

#endif
