/*
 *  connectnow home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <hildon/hildon.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <libintl.h>
#include <locale.h>
#include "connectnow-settings-dialog.h"
#include "connectnow-load-and-store.h"

void
select_and_set_icon(GtkButton* button, custom_icon_data* data)
{
  GtkWidget* dialog;
  GtkWidget* parent = gtk_widget_get_toplevel(GTK_WIDGET(button));
  dialog = hildon_file_chooser_dialog_new(GTK_WINDOW(parent),
					  GTK_FILE_CHOOSER_ACTION_OPEN);
  GtkFileFilter* fileFilter = gtk_file_filter_new();
  gtk_file_filter_add_pixbuf_formats(fileFilter);
  gtk_file_chooser_set_filter(GTK_FILE_CHOOSER(dialog), fileFilter);
  
  gtk_widget_show_all(GTK_WIDGET(dialog));
  int ret = gtk_dialog_run(GTK_DIALOG(dialog));
  if(ret == GTK_RESPONSE_OK)
  {

    gchar* filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
    GdkPixbuf* pixbuf = NULL;
    GdkPixbuf* scaled_pixbuf = NULL;
    pixbuf = load_image(filename);
    g_free(data->icon_name);
    data->icon_name = filename;
    
    scaled_pixbuf = gdk_pixbuf_scale_simple(pixbuf, HILDON_ICON_PIXEL_SIZE_FINGER,
					    HILDON_ICON_PIXEL_SIZE_FINGER,
					    GDK_INTERP_BILINEAR);
    

    gtk_button_set_image(GTK_BUTTON(data->icon_button), gtk_image_new_from_pixbuf(scaled_pixbuf));
    g_object_unref(pixbuf);
    g_object_unref(scaled_pixbuf);
  }
  gtk_widget_destroy(dialog);
}

void
connect_now_show_icon_selector(GtkButton* button, icon_data_t* icon_data)
{
  GtkWidget* dialog;
  GtkWidget* icon_box_1 = gtk_vbox_new(TRUE,0);
  GtkWidget* icon_box_2 = gtk_vbox_new(TRUE,0);
  GtkWidget* label_box = gtk_vbox_new(TRUE,0);
  GtkWidget* pan = hildon_pannable_area_new();
  GtkWidget* buttons[NUM_PREDEFINED_ICONS+1];
  GtkWidget* last_button = NULL;
  GtkWidget* hBox = gtk_hbox_new(FALSE, 3);
  gboolean predefined_is_selected = FALSE;
  int i;
  for(i = 0;i<NUM_PREDEFINED_ICONS;++i)
  {
    GtkWidget* connect_image;
    GtkWidget* disconnect_image;
    buttons[i] = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT,
							 GTK_RADIO_BUTTON(last_button));
    gtk_button_set_label(GTK_BUTTON(buttons[i]),
			 g_strdup(_predefined_icons[i][LABEL]));
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(buttons[i]),
			       FALSE);
    if(g_strcmp0(icon_data->connect_name, _predefined_icons[i][CONNECT])==0)
    {
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(buttons[i]),
				  TRUE);
      predefined_is_selected = TRUE;
    }
    GdkPixbuf* pixbuf;
    GdkPixbuf* scaled_pixbuf;
    pixbuf = load_image(_predefined_icons[i][CONNECT]);
    scaled_pixbuf = gdk_pixbuf_scale_simple(pixbuf, HILDON_ICON_PIXEL_SIZE_FINGER,
					    HILDON_ICON_PIXEL_SIZE_FINGER,
					    GDK_INTERP_BILINEAR);
    
    connect_image = gtk_image_new_from_pixbuf(scaled_pixbuf);
    g_object_unref(pixbuf);
    g_object_unref(scaled_pixbuf);
    pixbuf = load_image(_predefined_icons[i][DISCONNECT]);
    scaled_pixbuf = gdk_pixbuf_scale_simple(pixbuf, HILDON_ICON_PIXEL_SIZE_FINGER,
					    HILDON_ICON_PIXEL_SIZE_FINGER,
					    GDK_INTERP_BILINEAR);
    disconnect_image = gtk_image_new_from_pixbuf(scaled_pixbuf);
    g_object_unref(pixbuf);
    g_object_unref(scaled_pixbuf);

    gtk_box_pack_start(GTK_BOX(icon_box_1),
		       connect_image, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(icon_box_2),
		       disconnect_image, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(label_box),
		       buttons[i], TRUE, TRUE, 0);
    last_button = buttons[i];
  }
  buttons[NUM_PREDEFINED_ICONS] = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT,
									  GTK_RADIO_BUTTON(last_button));
  
  gtk_button_set_label(GTK_BUTTON(buttons[NUM_PREDEFINED_ICONS]),
		       "Custom");
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(buttons[NUM_PREDEFINED_ICONS]),
			     FALSE);

  custom_icon_data* connect_icon_data = g_new0(custom_icon_data, 1);
  custom_icon_data* disconnect_icon_data = g_new0(custom_icon_data, 1);
  connect_icon_data->icon_name = NULL;
  disconnect_icon_data->icon_name = NULL;
  connect_icon_data->icon_button = hildon_button_new(HILDON_SIZE_AUTO,
						HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  disconnect_icon_data->icon_button = hildon_button_new(HILDON_SIZE_AUTO,
						HILDON_BUTTON_ARRANGEMENT_VERTICAL);

  gtk_box_pack_start(GTK_BOX(icon_box_1),
		     connect_icon_data->icon_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(icon_box_2),
		     disconnect_icon_data->icon_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(label_box),
		     buttons[NUM_PREDEFINED_ICONS], TRUE, FALSE, 0);
  if(!predefined_is_selected &&
     icon_data->connect_name!=NULL)
  {
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(buttons[NUM_PREDEFINED_ICONS]),
				TRUE);
    
    GdkPixbuf* pixbuf;
    GdkPixbuf* scaled_pixbuf;
    pixbuf = load_image(icon_data->connect_name);
    scaled_pixbuf = gdk_pixbuf_scale_simple(pixbuf, HILDON_ICON_PIXEL_SIZE_FINGER,
					    HILDON_ICON_PIXEL_SIZE_FINGER,
					    GDK_INTERP_BILINEAR);
    gtk_button_set_image(GTK_BUTTON(connect_icon_data->icon_button), gtk_image_new_from_pixbuf(scaled_pixbuf));
    g_object_unref(pixbuf);
    g_object_unref(scaled_pixbuf);
    pixbuf = load_image(icon_data->disconnect_name);
    scaled_pixbuf = gdk_pixbuf_scale_simple(pixbuf, HILDON_ICON_PIXEL_SIZE_FINGER,
					    HILDON_ICON_PIXEL_SIZE_FINGER,
					    GDK_INTERP_BILINEAR);
    gtk_button_set_image(GTK_BUTTON(disconnect_icon_data->icon_button), gtk_image_new_from_pixbuf(scaled_pixbuf));
    g_object_unref(pixbuf);
    g_object_unref(scaled_pixbuf);
  }
  
  g_signal_connect(connect_icon_data->icon_button, "clicked", G_CALLBACK(select_and_set_icon), connect_icon_data);
  g_signal_connect(disconnect_icon_data->icon_button, "clicked", G_CALLBACK(select_and_set_icon), disconnect_icon_data);
  gtk_box_pack_start(GTK_BOX(hBox), icon_box_1, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(hBox), icon_box_2, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(hBox), label_box, TRUE, TRUE, 3);
  hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pan),
					 hBox);
  
  dialog = gtk_dialog_new_with_buttons("Icon",
				       NULL,
				       0,
				       dgettext("hildon-libs", "wdgt_bd_done"),
				       GTK_RESPONSE_ACCEPT,
				       NULL);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), pan);

  gtk_window_set_default_size(GTK_WINDOW(dialog), -1, 300);
  gtk_widget_show_all(dialog);
  if(gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
  {
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(buttons[NUM_PREDEFINED_ICONS])))
    {
      if(connect_icon_data->icon_name &&
	 disconnect_icon_data->icon_name)
      {
	icon_data->connect_name = g_strdup(connect_icon_data->icon_name);
	icon_data->disconnect_name = g_strdup(disconnect_icon_data->icon_name);
      }
    }
    else
    {
      for(i = 0;i<NUM_PREDEFINED_ICONS;++i)
      {
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(buttons[i])))
	{
	  icon_data->connect_name = g_strdup(_predefined_icons[i][CONNECT]);
	  icon_data->disconnect_name= g_strdup(_predefined_icons[i][DISCONNECT]);
	  break;
	}
      }
    }
    GdkPixbuf* pixbuf = load_image(icon_data->connect_name);
    gtk_image_set_from_pixbuf(GTK_IMAGE(icon_data->connect_icon),
			      pixbuf);
    g_object_unref(pixbuf);
    pixbuf = load_image(icon_data->disconnect_name);
    gtk_image_set_from_pixbuf(GTK_IMAGE(icon_data->disconnect_icon),
			      pixbuf);
    g_object_unref(pixbuf);
  }
  g_free(connect_icon_data->icon_name);
  g_free(disconnect_icon_data->icon_name);
  g_free(connect_icon_data);
  g_free(disconnect_icon_data);
  gtk_widget_destroy (dialog);
}
