/*
 *  connectnow home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef CONNECTNOW_HOME_PLUGIN_H
#define CONNECTNOW_HOME_PLUGIN_H

#include <glib-object.h>
#include <conic.h>
#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _ConnectNowHomePlugin ConnectNowHomePlugin;
typedef struct _ConnectNowHomePluginClass ConnectNowHomePluginClass;

#define CONNECT_NOW_HOME_PLUGIN_TYPE (connect_now_home_plugin_get_type())

#define CONNECT_NOW_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								 CONNECT_NOW_HOME_PLUGIN_TYPE, ConnectNowHomePlugin))

#define CONNECT_NOW_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
								CONNECT_NOW_HOME_PLUGIN_TYPE))

#define CONNECT_NOW_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
									   CONNECT_NOW_HOME_PLUGIN_TYPE, ConnectNowHomePluginClass))

struct _ConnectNowHomePlugin
{
  HDHomePluginItem hitem;
  gchar* connection_id;
  gchar* connection_name;
  gchar* current_connection_id;
  ConIcConnection* con;
  gint this_connection_state;
  gboolean connect_now;

  gchar* iD;
  gchar* connectedImageName;
  gchar* disconnectedImageName;
  GdkPixbuf* connectedImage;
  GdkPixbuf* disconnectedImage;
};

struct _ConnectNowHomePluginClass
{
  HDHomePluginItemClass parent_class;

};

GType connect_now_home_plugin_get_type(void);

#endif
