#include "processdialog.h"
#include "ui_processdialog.h"

#include "configreader.h"
#include "ui_configreader.h"

#include "writewindow.h"
#include "ui_writewindow.h"

processDialog::processDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::processDialog)
{
    // procParent is a pointer to processDialog's parent (configReader)
    procParent = (configReader*) parent;

    ui->setupUi(this);

    procParent->outData = "";

    connect(&gconfProcess, SIGNAL(readyReadStandardOutput()),
            this, SLOT(gconfWrite()));
    connect(&gconfProcess, SIGNAL(finished(int)),
            this, SLOT(gconfFinished()));

    this->adjustSize();
}

processDialog::~processDialog()
{
    delete ui;
}





// The main GConf reader process, reads all GConf values
void processDialog::gconfStart() {
    // Start the process
    gconfProcess.start("gconftool -R /", QProcess::ReadOnly);
}





void processDialog::gconfWrite() {
    // Put output in a QString
    procParent->outData.append(gconfProcess.readAllStandardOutput());
}





void processDialog::gconfFinished() {
    // Stop the process, close this dialog
    gconfProcess.close();
    this->close();

    // Open the window for HTML writing
    writeWin = new writeWindow(procParent);
    writeWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    writeWin->setAttribute(Qt::WA_DeleteOnClose);
    procParent->cameFrom = "process";
    writeWin->show();
}
