#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include "configreader.h"
#include "ui_configreader.h"

settingsDialog::settingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settingsDialog)
{
    ui->setupUi(this);
    ui->filenameExLbl->setStyleSheet("color: deepskyblue;");
    ui->titleExLbl->setStyleSheet("color: deepskyblue;");

    // settParent is settDialog's parent (configReader)
    settParent = (configReader*) parent;

    ui->explLbl->adjustSize();

    // Set dateFormat radiobuttons acoording to current values
    ui->radDDMMYYYY->setChecked(false);
    ui->radMMDDYYYY->setChecked(false);
    ui->radYYYYDDMM->setChecked(false);
    ui->radYYYYMMDD->setChecked(false);
    if(settParent->dateFormat == "ddMMyyyy")
        ui->radDDMMYYYY->setChecked(true);
    else if(settParent->dateFormat == "MMddyyyy")
        ui->radMMDDYYYY->setChecked(true);
    else if(settParent->dateFormat == "yyyyddMM")
        ui->radYYYYDDMM->setChecked(true);
    else if(settParent->dateFormat == "yyyyMMdd")
        ui->radYYYYMMDD->setChecked(true);

    // Set separator radiobuttons according to current values
    ui->sepDash->setChecked(false);
    ui->sepSlash->setChecked(false);
    ui->sepNone->setChecked(false);
    if(settParent->dateSep == "-")
        ui->sepDash->setChecked(true);
    else if(settParent->dateSep == "/")
        ui->sepSlash->setChecked(true);
    else if(settParent->dateSep == "")
        ui->sepNone->setChecked(true);

    connect(ui->radDDMMYYYY, SIGNAL(toggled(bool)),
            this, SLOT(ddmmyyyy()));
    connect(ui->radMMDDYYYY, SIGNAL(toggled(bool)),
            this, SLOT(mmddyyyy()));
    connect(ui->radYYYYDDMM, SIGNAL(toggled(bool)),
            this, SLOT(yyyyddmm()));
    connect(ui->radYYYYMMDD, SIGNAL(toggled(bool)),
            this, SLOT(yyyymmdd()));

    connect(ui->sepDash, SIGNAL(toggled(bool)),
            this, SLOT(sepDash()));
    connect(ui->sepSlash, SIGNAL(toggled(bool)),
            this, SLOT(sepSlash()));
    connect(ui->sepNone, SIGNAL(toggled(bool)),
            this, SLOT(sepNone()));

    connect(this->ui->btnBox, SIGNAL(accepted()),
            this, SLOT(close()));

    // Update the radiobuttons and examples
    updateRadioBtns();
    updateExamples();
    this->adjustSize();
}

settingsDialog::~settingsDialog()
{
    delete ui;
}





// Change settParent->dateFormat and save the date_format GConf values
void settingsDialog::ddmmyyyy() {
    settParent->dateFormat = "ddMMyyyy";
    settParent->setDateFormatTitle();
    updateExamples();
    system("gconftool -s /apps/maemo/configreader/date_format -t string \"ddMMyyyy\"");
}
void settingsDialog::mmddyyyy() {
    settParent->dateFormat = "MMddyyyy";
    settParent->setDateFormatTitle();
    updateExamples();
    system("gconftool -s /apps/maemo/configreader/date_format -t string \"MMddyyyy\"");
}
void settingsDialog::yyyyddmm() {
    settParent->dateFormat = "yyyyddMM";
    settParent->setDateFormatTitle();
    updateExamples();
    system("gconftool -s /apps/maemo/configreader/date_format -t string \"yyyyddMM\"");
}
void settingsDialog::yyyymmdd() {
    settParent->dateFormat = "yyyyMMdd";
    settParent->setDateFormatTitle();
    updateExamples();
    system("gconftool -s /apps/maemo/configreader/date_format -t string \"yyyyMMdd\"");
}





// Change settParent->dateSep, save date_sep GConf value and update settParent->dateFormat radiobuttons
void settingsDialog::sepDash() {
    settParent->dateSep = "-";
    settParent->setDateFormatTitle();
    updateExamples();
    updateRadioBtns();
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"dash\"");
}
void settingsDialog::sepSlash() {
    settParent->dateSep = "/";
    settParent->setDateFormatTitle();
    updateExamples();
    updateRadioBtns();
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"slash\"");
}
void settingsDialog::sepNone() {
    settParent->dateSep = "";
    settParent->setDateFormatTitle();
    updateExamples();
    updateRadioBtns();
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"none\"");
}
void settingsDialog::updateRadioBtns() {
    // Put the separator in the settParent->dateFormat radio buttons
    ui->radDDMMYYYY->setText("DD" + settParent->dateSep + "MM" + settParent->dateSep + "YYYY");
    ui->radMMDDYYYY->setText("MM" + settParent->dateSep + "DD" + settParent->dateSep + "YYYY");
    ui->radYYYYDDMM->setText("YYYY" + settParent->dateSep + "DD" + settParent->dateSep + "MM");
    ui->radYYYYMMDD->setText("YYYY" + settParent->dateSep + "MM" + settParent->dateSep + "DD");
}





void settingsDialog::updateExamples() {
    // configreaderDDMMYYYY-HHMMSS.html
    ui->filenameExLbl->setText("configreader"
                               + settParent->dateFormat.toUpper()
                               + "-HHMMS.html");
    // DD-MM-YYYY, HH:MM:SS (Config Reader)
    ui->titleExLbl->setText(settParent->dateFormatTitle.toUpper()
                            + ", HH:MM:SS (Config Reader)");
}
