#include "processdialog.h"
#include "ui_processdialog.h"

#include "configreader.h"
#include "ui_configreader.h"

processDialog::processDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::processDialog)
{
    ui->setupUi(this);
    // procParent is a pointer to processWindow's parent (configReader)
    procParent = (configReader*) parent;

    procParent->outData = "";

    connect(&gconfProcess, SIGNAL(readyReadStandardOutput()),
            this, SLOT(gconfWrite()));
    connect(&gconfProcess, SIGNAL(finished(int)),
            this, SLOT(gconfFinished()));

    this->adjustSize();
}

processDialog::~processDialog()
{
    delete ui;
}





// The main GConf reader process, reads all GConf values
void processDialog::gconfStart() {
    // Start the process
    gconfProcess.start("gconftool -R /", QProcess::ReadOnly);
}





void processDialog::gconfWrite() {
    // Put output in a QString
    procParent->outData.append(gconfProcess.readAllStandardOutput());
}





void processDialog::gconfFinished() {
    // Stop the process
    gconfProcess.close();
    this->close();
}
