#include "configreader.h"
#include "ui_configreader.h"

#include "aboutdialog.h"
#include "ui_aboutdialog.h"

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include "processdialog.h"
#include "ui_processdialog.h"

#include "writewindow.h"
#include "ui_writewindow.h"

#include <QMessageBox>

configReader::configReader(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::configReader)
{
    ui->setupUi(this);
    // Set startLabel text color to black
    ui->startLabel->setStyleSheet("color: black;");
    // Set the background
    this->setStyleSheet("QMainWindow { background-image: url(:/gfx/backstart.png) }");
    // Make the top menu
    setupCRMenu();

    // Read GConf values after clearing them
    saveDirConf.clear();
    saveDir = "/home/user/MyDocs";
    getSaveDir();

    dateSepConf = "";
    dateSep = "";
    getSep();

    dateFormat.clear(); // For saveFile
    dateFormatTitle.clear(); // For html document title
    getDateFormat();

    connect(ui->startBtn, SIGNAL(clicked()),
            this, SLOT(openProcDialog()));
}
configReader::~configReader() {
    delete ui;
}





void configReader::setupCRMenu() {
    // The main menu
    crMenu.setParent(this);
    crMenu.addMenu("");
    crMenu.addAction("About...", this, SLOT(createAboutDialog()));
    crMenu.addAction("About Qt...", this, SLOT(createAboutQtDialog()));
    crMenu.addAction("Settings", this, SLOT(createSettingsDialog()));
}
void configReader::createAboutDialog() {
    abtDialog = new aboutDialog(this);
    abtDialog->show();
}
void configReader::createAboutQtDialog() {
    QMessageBox::aboutQt(this, "About Qt");
}
void configReader::createSettingsDialog() {
    settDialog = new settingsDialog(this);
    settDialog->show();
}





void configReader::getSaveDir() {
    // Start process
    saveDirProcess.start("gconftool -g /apps/maemo/configreader/save_dir", QProcess::ReadOnly);
    connect(&saveDirProcess, SIGNAL(finished(int)),
            this, SLOT(saveDirReadReady()));
}
void configReader::saveDirReadReady() {
    // Put the key into a temporary string, then put it in QDir saveDir
    saveDirConf.append(saveDirProcess.readAllStandardOutput());
    // Remove newline character(s)
    // saveDir is now correctly loaded
    saveDirConf.replace("\n", "", Qt::CaseInsensitive);
    saveDir.setPath(saveDirConf);

    // If the path doesn't contain /home/user/MyDocs, make it /home/user/MyDocs
    if(!saveDir.absolutePath().contains("/home/user/MyDocs"))
        saveDir.setPath("/home/user/MyDocs");
    // If the path is invalid, set it on /home/user/MyDocs
    if(saveDir.exists() == false)
        saveDir.setPath("/home/user/MyDocs");

    // Stop process
    saveDirProcess.close();
}





void configReader::getSep() {
    // Start process
    sepProcess.start("gconftool -g /apps/maemo/configreader/date_sep", QProcess::ReadOnly);
    connect(&sepProcess, SIGNAL(finished(int)),
            this, SLOT(sepReadReady()));
}
void configReader::sepReadReady() {
    // Put output in a separate string, "dash", "slash" or "none"
    dateSepConf.append(sepProcess.readAllStandardOutput());
    // Remove newline characters
    dateSepConf.replace("\n", "", Qt::CaseInsensitive);

    // Convert the above string to "-", "/" or ""
    if(dateSepConf.contains("dash", Qt::CaseSensitive))
        dateSep = "-";
    else if(dateSepConf.contains("slash", Qt::CaseSensitive))
        dateSep = "/";
    else if(dateSepConf.contains("none", Qt::CaseSensitive))
        dateSep = "";
    else { // If dateSepConf is invalid, set it on default and store it in GConf
        dateSep = "-";
        system("gconftool -s /apps/maemo/configreader/date_sep -t string \"dash\"");
    }

    // Stop process
    sepProcess.close();
}





void configReader::getDateFormat() {
    // Start process
    dateProcess.start("gconftool -g /apps/maemo/configreader/date_format", QProcess::ReadOnly);
    connect(&dateProcess, SIGNAL(finished(int)),
            this, SLOT(dateReadReady()));
}
void configReader::dateReadReady() {
    dateFormat.append(dateProcess.readAllStandardOutput());

    // If dateFormat is invalid, set it on default and store it in GConf
    if(!dateFormat.contains("ddMMyy", Qt::CaseSensitive)
        && !dateFormat.contains("MMddyy", Qt::CaseSensitive)
        && !dateFormat.contains("yyddMM", Qt::CaseSensitive)
        && !dateFormat.contains("yyMMdd", Qt::CaseSensitive)) {
            dateFormat == "ddMMyy";
            system("gconftool -s /apps/maemo/configreader/date_format -t string \"ddMMyy\"");
    }

    // Remove newline character(s)
    // dateFormat is now correctly loaded
    dateFormat.replace("\n", "", Qt::CaseInsensitive);

    // dateFormatTitle (for HTML) takes value of dateFormat (GConf value)
    dateFormatTitle = dateFormat;

    // Only edit when not "none", replacing no character doesn't make sense
    if(dateSep != "") {
        // Adjust to the new separator format
        // Example: "ddMMyy"
        dateFormatTitle.replace("dd", dateSep + "dd" + dateSep, Qt::CaseSensitive); // "-dd-"
        dateFormatTitle.replace("MM", dateSep + "MM" + dateSep, Qt::CaseSensitive); // "-MM-"
        dateFormatTitle.replace("yy", dateSep + "yy" + dateSep, Qt::CaseSensitive); // "-yy-"
        // Example: "-dd--MM--yy-"
        dateFormatTitle.remove(0,1); // Remove the first separator, "dd--MM--yy-"
        dateFormatTitle.chop(1);     // Remove the last separator, "dd--MM--yy"
        dateFormatTitle.replace(dateSep + dateSep, dateSep, Qt::CaseInsensitive); // Remove double separators, "dd-MM-yy"
    }

    // Stop process
    dateProcess.close();
}





void configReader::openProcDialog() {
    // Open the dialog for processing "gconftool -R /"
    procDialog = new processDialog(this);
    procDialog->setAttribute(Qt::WA_DeleteOnClose);
    connect(procDialog, SIGNAL(destroyed()),
            this, SLOT(openWriteWin()));
    procDialog->show();
    procDialog->gconfStart();
}





void configReader::openWriteWin() {
    // Open the window for HTML writing
    writeWin = new writeWindow(this);
    writeWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    writeWin->setAttribute(Qt::WA_DeleteOnClose);
    writeWin->show();
}
