#!/usr/bin/env python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2.1.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
# Project:coN900
# Author:humble

import pygtk
pygtk.require('2.0')
import gtk
import os
import hildon
import pango



class GUI:

    def Edit_Script(self, widget):
        
        messagedialog = gtk.MessageDialog(self.window, 0, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, "Are You Sure You Want To Edit Your OptimizeN900 Script?")
        response = messagedialog.run()
        messagedialog.destroy()
        
        if response == gtk.RESPONSE_YES :
           window = hildon.StackableWindow()
           window.set_title("Editor")
           window.set_border_width(1)
           window.set_default_size(200, 200)
            
           scrolledwindow = gtk.ScrolledWindow()
           scrolledwindow.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        
           self.textbuffer = gtk.TextBuffer()
           textview = gtk.TextView(self.textbuffer)
           textview.set_wrap_mode(gtk.WRAP_WORD)
        
           button_load = gtk.Button("Open OptimizeN900 Script")
           self.button_save = gtk.Button("Save OptimizeN900 Script")
           self.button_save.set_sensitive(False)

           vbox = gtk.VBox(False, 5)
           hbox = gtk.HBox(False, 5)
           vbox.pack_start(scrolledwindow, True, True, 0)
           vbox.pack_start(hbox, False, False, 0)
           hbox.pack_end(self.button_save, False, False, 0)
           hbox.pack_end(button_load, False, False, 0)
           scrolledwindow.add(textview)
        
           #window.connect("destroy", lambda w: gtk.main_quit())
           self.textbuffer.connect("changed", self.edited)
           button_load.connect("clicked", self.load_file)
           self.button_save.connect("clicked", self.save_file)
        
           window.add(vbox)
           window.show_all()

    def edited(self, widget):
        if self.textbuffer.get_modified():
            self.button_save.set_sensitive(True)
        else:
            self.button_save.set_sensitive(False)
    
    def load_file(self, widget):
        file = open("/usr/local/bin/OptimizeN900", "r")
        text = file.read()
        file.close()
        
        self.textbuffer.set_text(text)
    
    def save_file(self, widget):
        start, end = self.textbuffer.get_bounds()
    
        text = self.textbuffer.get_text(start, end, False)
        file = open("/usr/local/bin/OptimizeN900", "w")
        file.write(text)
        file.close()
        
        self.textbuffer.set_modified(False)
        self.button_save.set_sensitive(False)
     
    def Find_Process(self, widget):
        os.system("top -b -n 1 > /home/findump.txt")
        
        window = hildon.StackableWindow()
        stack = hildon.WindowStack()
        stack.push_1(window)
        
        window.set_title("Found Process")
        window.set_border_width(1)
        window.set_default_size(200, 200)
        window.set_border_width(1)
        window.set_default_size(800, 480)
        
        texteditorsw = gtk.ScrolledWindow()
        texteditorsw.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
                
        texteditor = gtk.TextView(buffer=None)
        textbuffer = texteditor.get_buffer()
        
        file = open("/home/findump.txt", 'r')
        contents = file.read()
        file.close()
        
        textbuffer.set_text(contents)
        texteditor.set_editable(True)
        texteditor.set_justification(gtk.JUSTIFY_LEFT)
        
        texteditorsw.add(texteditor)
        
        vbox = gtk.VBox(False, 0)
        vbox.pack_start(texteditorsw, True, True, 20)
        
        window.add(vbox)
        window.show_all()
        
    def Test_Script(self, widget):
        
        messagedialog = gtk.MessageDialog(self.window, 0, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, "Are You Sure You Want To RUN Your OptimizeN900 Script?")
        response = messagedialog.run()
        messagedialog.destroy()
        
        if response == gtk.RESPONSE_YES :
            os.system("sh /usr/local/bin/OptimizeN900") 
        
    def View_Script(self, widget):
        window = hildon.StackableWindow()
        window.set_title("Current Script")
        window.set_border_width(1)
        window.set_default_size(200, 200)
        
        texteditorsw = gtk.ScrolledWindow()
        texteditorsw.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
                
        texteditor = gtk.TextView(buffer=None)
        textbuffer = texteditor.get_buffer()
        
        file = open("/usr/local/bin/OptimizeN900", 'r')
        contents = file.read()
        file.close()
        
        textbuffer.set_text(contents)
        texteditor.set_editable(True)
        texteditor.set_justification(gtk.JUSTIFY_LEFT)
        
        texteditorsw.add(texteditor)
        
        vbox = gtk.VBox(False, 0)
        vbox.pack_start(texteditorsw, True, True, 20)
        
        window.add(vbox)
        window.show_all()

    def Restore_script(self, messagedialog):
        messagedialog = gtk.MessageDialog(self.window, 0, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, "Are You Sure You Want To Restore Your OptimizeN900 Script?")
        response = messagedialog.run()
        messagedialog.destroy()
        
        if response == gtk.RESPONSE_YES :
            os.system( "sudo python '/home/opt/CON900/Restore'")
        elif response == gtk.RESPONSE_NO :
            pass
               
    def delete_event(self, widget, event):
        os.system ("rm -Rf /home/findump.txt")
        gtk.main_quit()
        return False
        
    def __init__(self):
    
        self.window = hildon.StackableWindow()
        self.window.set_title("CON900")

        self.window.connect("delete_event", self.delete_event)

        self.window.set_border_width(20)
        self.window.set_default_size(800, 480)
        
        aboutdialog = gtk.AboutDialog()        
        aboutdialog.set_name("CON900")
        aboutdialog.set_version("0.0.8-7")
        aboutdialog.set_comments("This application was created to ease the customization of OptimizeN900 Script. It's coded in PyGTK.")
        aboutdialog.set_license("GNU LGPL 2.1")
        aboutdialog.set_website("humblecon900.garage.maemo.org")
        aboutdialog.set_authors(["humble"])

        aboutdialog.run()
        aboutdialog.destroy()
        
        hbox = gtk.HBox(True, 10)
        vbox_left = gtk.VBox(True, 10)
        vbox_middle = gtk.VBox(True, 10)
        vbox_right = gtk.VBox(True, 10)
        
        hbox.pack_start(vbox_left)
        hbox.pack_start(vbox_middle)
        hbox.pack_start(vbox_right)
        
        
        label = gtk.Label("OptimizeN900\nEditor")
        label.modify_font(pango.FontDescription("tahoma 24"))
        label.set_line_wrap(True)
        vbox_left.pack_start(label)
        
        button6 =gtk.Button("TEST")
        button6.connect("clicked", self.Test_Script)
        vbox_left.pack_start(button6)

        button1 = gtk.Button("Find")
        button1.connect("clicked", self.Find_Process)
        vbox_middle.pack_start(button1) 

	button2 = gtk.Button("Edit")
        button2.connect("clicked", self.Edit_Script)
        vbox_right.pack_start(button2)

        button3 = gtk.Button("Restore")
        button3.connect("clicked", self.Restore_script)
        vbox_right.pack_start(button3)

	button4 = gtk.Button("Quit")
	button4.connect("clicked", lambda w: gtk.main_quit(os.system ("rm -Rf /home/findump.txt")))
        vbox_left.pack_end(button4)
        
        button5 = gtk.Button("View")
        button5.connect("clicked", self.View_Script)
        vbox_middle.pack_end(button5)
        
        self.window.add(hbox)
        self.window.show_all()

def main():
    gtk.main()
    return 0       

if __name__ == "__main__":
    GUI()
    main()
