/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#ifndef SESSIONTABWIDGET_H
#define SESSIONTABWIDGET_H

#include "tabwidget.h"
#include <ircbuffer.h>
#include <QHash>

class Session;
class MessageView;
class CommandEngine;
struct Connection;

class SessionTabWidget : public TabWidget
{
    Q_OBJECT

public:
    SessionTabWidget(Session* session, QWidget* parent = 0);

    Session* session() const;
    QStringList channels() const;

public slots:
    void openView(const QString& receiver);
    void closeCurrentView(const QString& message = QString());
    void closeView(const QString& receiver, const QString& message = QString());

signals:
    void titleChanged(const QString& title);
    void disconnectFrom(const QString& message);

private slots:
    void connected();
    void reconnecting();
    void disconnected();
    void bufferAdded(Irc::Buffer* buffer);
    void bufferRemoved(Irc::Buffer* buffer);
    void send(const QString& receiver, const QString& message);
    void tabActivated(int index);
    void delayedTabReset();
    void delayedTabResetTimeout();
    void nameTab(MessageView* view);
    void alertTab(MessageView* view, bool on);
    void highlightTab(MessageView* view, bool on);
    void applySettings();

private:
    struct SessionTabWidgetData
    {
        int connectCounter;
        QList<int> delayedIndexes;
        Session* session;
        CommandEngine* engine;
        QHash<QString, MessageView*> views;
    } d;
};

#endif // SESSIONTABWIDGET_H
