/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#include "connectionspage.h"
#include "connectionwizard.h"
#include "application.h"

ConnectionsPage::ConnectionsPage(QWidget* parent) : QWidget(parent)
{
    ui.setupUi(this);

    ui.connectionTree->header()->setResizeMode(0, QHeaderView::Stretch);
    ui.connectionTree->header()->setResizeMode(1, QHeaderView::Stretch);
    ui.connectionTree->header()->setResizeMode(2, QHeaderView::ResizeToContents);

    connect(ui.addButton, SIGNAL(clicked()), this, SLOT(addConnection()));
    connect(ui.editButton, SIGNAL(clicked()), this, SLOT(editConnection()));
    connect(ui.removeButton, SIGNAL(clicked()), this, SLOT(removeConnection()));

    connect(ui.connectionTree, SIGNAL(itemSelectionChanged()), this, SLOT(updateUi()));
    connect(ui.connectionTree, SIGNAL(itemDoubleClicked(QTreeWidgetItem*, int)), this, SLOT(connectTo(QTreeWidgetItem*)));

    connect(qApp, SIGNAL(connectionsChanged(Connections)), this, SLOT(updateConnections(Connections)));
    updateConnections(Application::connections());
}

void ConnectionsPage::addConnection()
{
    ConnectionWizard wizard;
    if (wizard.exec())
    {
        Connection connection = wizard.connection();
        Application::setConnections(Application::connections() << connection);
        emit connectTo(connection);
    }
}

void ConnectionsPage::editConnection()
{
    QTreeWidgetItem* item = ui.connectionTree->selectedItems().value(0);
    int index = ui.connectionTree->indexOfTopLevelItem(item);
    if (index != -1)
    {
        ConnectionWizard wizard;
        wizard.setConnection(Application::connections().at(index));
        if (wizard.exec())
            Application::setConnection(index, wizard.connection());
    }
}

void ConnectionsPage::removeConnection()
{
    QTreeWidgetItem* item = ui.connectionTree->selectedItems().value(0);
    int index = ui.connectionTree->indexOfTopLevelItem(item);
    if (index != -1)
    {
        Connections connections = Application::connections();
        connections.removeAt(index);
        Application::setConnections(connections);
    }
}

void ConnectionsPage::connectTo(QTreeWidgetItem* item)
{
    int index = ui.connectionTree->indexOfTopLevelItem(item);
    if (index != -1)
        emit connectTo(Application::connections().at(index));
}

void ConnectionsPage::updateConnections(const Connections& connections)
{
    ui.connectionTree->clear();

    foreach (const Connection& connection, connections)
    {
        QTreeWidgetItem* item = new QTreeWidgetItem(ui.connectionTree);
        item->setText(0, connection.name);
        item->setText(1, connection.host);
        item->setData(2, Qt::DisplayRole, connection.port);
    }

    updateUi();
}

void ConnectionsPage::updateUi()
{
    int count = ui.connectionTree->selectedItems().count();
    ui.editButton->setEnabled(count == 1);
    ui.removeButton->setEnabled(count > 0);
}
