######################################################################
# Communi
######################################################################

TEMPLATE = app
TARGET = communi
DESTDIR = bin
DEPENDPATH += . src
INCLUDEPATH += . src
CONFIG += silent libircclient-qt
DEFINES += VERSION=\\\"0.2.0\\\"
QT += network script xml
CONFIG(debug, debug|release) {
    QT += scripttools
}

OBJECTS_DIR = release
MOC_DIR = release
RCC_DIR = release
UI_DIR = release

QT_VERSION = $$[QT_VERSION]
QT_VERSION = $$split(QT_VERSION, ".")
QT_VER_MAJ = $$member(QT_VERSION, 0)
QT_VER_MIN = $$member(QT_VERSION, 1)

lessThan(QT_VER_MAJ, 4) | lessThan(QT_VER_MIN, 4) {
    error(Communi requires Qt 4.4 or newer but Qt $$[QT_VERSION] was detected.)
}

RESOURCES += communi.qrc
win32:RC_FILE = communi.rc
mac:LIBS += -L/opt/local/lib -l$$qtLibraryTarget(icuuc) -l$$qtLibraryTarget(icui18n) -l$$qtLibraryTarget(icudata)

include(src/src.pri)
include(translations/translations.pri)

unix {
    # /usr/bin/dbbrowser
    # /usr/share/applications/hildon/dbbrowser.desktop
    # /usr/share/icons/hicolor/64x64/apps/dbbrowser.png

    # VARIABLES
    isEmpty(PREFIX):PREFIX = debian
    BINDIR = $$PREFIX/$${TARGET}/usr/bin
    DATADIR = $$PREFIX/$${TARGET}/usr/share
    DEFINES += DATADIR=\"$$DATADIR\" \
        PKGDATADIR=\"$$PKGDATADIR\"

    # MAKE INSTALL
    INSTALLS += target \
        desktop \
        icon64

    target.path = $$BINDIR
    desktop.path = $$DATADIR/applications/hildon
    desktop.files += $${TARGET}.desktop

    #iconxpm.path = $$DATADIR/pixmap
    #iconxpm.files += data/48x48/$${TARGET}.xpm
    #icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    #icon26.files += data/26x26/$${TARGET}.png
    #icon40.path = $$DATADIR/icons/hicolor/40x40/apps
    #icon40.files += data/40x40/$${TARGET}.png
    #icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    #icon48.files += data/48x48/$${TARGET}.png
    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += $${TARGET}.png
}
