#ifndef COLUMBUSDIALOGWAYPOINTSITEMMENU_H
#define COLUMBUSDIALOGWAYPOINTSITEMMENU_H

#include "widgets/ColumbusDialog.h"

#include <rx/columbus/ColumbusWaypoint.h>

class ColumbusDialogWaypointsItemMenuPrivate;

class ColumbusDialogWaypointsItemMenu : public ColumbusDialog
{
    Q_OBJECT

    Q_PROPERTY(ColumbusWaypoint waypoint READ waypoint WRITE setWaypoint)

public:
    explicit ColumbusDialogWaypointsItemMenu(QWidget *parent = 0);
            ~ColumbusDialogWaypointsItemMenu();

    ColumbusWaypoint waypoint() const;

signals:
    void navigateTo     (const ColumbusWaypoint &waypoint);
    void updateWaypoint (const ColumbusWaypoint &waypoint);
    void deleteWaypoint (const ColumbusWaypoint &waypoint);

public slots:
    void setWaypoint(const ColumbusWaypoint &waypoint);

protected slots:
    void setupUi();
    void updateUi();

    void onButtonPressed();

private:
    ColumbusDialogWaypointsItemMenuPrivate *d;
};

#endif // COLUMBUSDIALOGWAYPOINTSITEMMENU_H
