#include "ColumbusDialogRoutesForm.h"

#include <QtGui>

class ColumbusDialogRoutesFormPrivate
{
public:
    ColumbusDialogRoutesFormPrivate();

    QLineEdit *name;
    QPushButton *btnSave;
};

ColumbusDialogRoutesFormPrivate::ColumbusDialogRoutesFormPrivate()
    : name(NULL),
      btnSave(NULL)
{ /* ... */ }

ColumbusDialogRoutesForm::ColumbusDialogRoutesForm(QWidget *parent)
    : ColumbusDialog(parent),
      d(new ColumbusDialogRoutesFormPrivate)
{
    this->setupUi();
}

ColumbusDialogRoutesForm::~ColumbusDialogRoutesForm()
{
    delete this->d;
}

void ColumbusDialogRoutesForm::setupUi()
{
    QVBoxLayout *vbox = new QVBoxLayout(this);
    QFormLayout *form = new QFormLayout;

    form->setLabelAlignment(Qt::AlignRight | Qt::AlignHCenter);

    d->name = new QLineEdit(this);
    d->name->setPlaceholderText(tr("Enter Route Name"));

    d->btnSave = new QPushButton(tr("Save"), this);

    form->addRow(tr("Name"), d->name);

    vbox->addLayout(form);
    vbox->addWidget(d->btnSave);
}

void ColumbusDialogRoutesForm::updateUi()
{

}
