#include "ColumbusDialogRoutes.h"
#include "ColumbusDialogRoutesForm.h"
#include "ColumbusDialogRoutesView.h"

#include "widgets/RouteListDelegate.h"

#include <QtGui>

class ColumbusDialogRoutesPrivate
{
public:
    ColumbusDialogRoutesPrivate();

    QMessageBox *deleteconfirm;

    ColumbusDialogRoutesForm *form;
    ColumbusDialogRoutesView *view;

    RouteListDelegate *delegate;

    QListView *listview;
    QScrollArea *scrollarea;

    QPushButton *btnCreate;
    QPushButton *btnClear;
};

ColumbusDialogRoutesPrivate::ColumbusDialogRoutesPrivate()
    : deleteconfirm(NULL),
      form(NULL),
      view(NULL),
      delegate(NULL),
      listview(NULL),
      scrollarea(NULL),
      btnCreate(NULL),
      btnClear(NULL)
{ /* ... */ }

ColumbusDialogRoutes::ColumbusDialogRoutes(QWidget *parent)
    : ColumbusDialog(parent), d(new ColumbusDialogRoutesPrivate)
{
    this->setWindowTitle(tr("Routing"));
    this->setupUi();
}

ColumbusDialogRoutes::~ColumbusDialogRoutes()
{
    delete this->d;
}

void ColumbusDialogRoutes::setController(ApplicationController *controller)
{
    ColumbusDialog::setController(controller);

    if(controller != NULL)
    {
        this->updateUi();
    }
}

void ColumbusDialogRoutes::setupUi()
{
    QVBoxLayout *vbox = new QVBoxLayout(this);
    QHBoxLayout *hbox = new QHBoxLayout(this);

    d->deleteconfirm = new QMessageBox(this);
    d->deleteconfirm->setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    d->deleteconfirm->setWindowTitle(tr("Delete Route?"));

    d->form = new ColumbusDialogRoutesForm(this);
    d->view = new ColumbusDialogRoutesView(this);

    d->listview = new QListView(this);
    d->listview->setEditTriggers(QAbstractItemView::NoEditTriggers);
    d->listview->setAlternatingRowColors(true);

    d->scrollarea = new QScrollArea(this);
    d->scrollarea->setWidget(d->listview);
    d->scrollarea->setWidgetResizable(true);

    d->btnCreate = new QPushButton(tr("Create"), this);
    d->btnClear  = new QPushButton(tr("Clear Current"), this);

    vbox->addWidget(d->scrollarea, 1);
    hbox->addWidget(d->btnCreate);
    hbox->addWidget(d->btnClear);
    vbox->addLayout(hbox);

    QObject::connect(d->listview, SIGNAL(clicked(QModelIndex)), this, SLOT(onRouteSelected(QModelIndex)));
    QObject::connect(d->btnCreate, SIGNAL(clicked()), this, SLOT(showCreateForm()));
    QObject::connect(d->btnClear, SIGNAL(clicked()), this, SLOT(onRouteClear()));
}

void ColumbusDialogRoutes::updateUi()
{

}

void ColumbusDialogRoutes::showCreateForm()
{
    QObject::connect(d->form, SIGNAL(finished(int)), this, SLOT(onCreateFormFinished(int)));

    d->form->setWindowTitle(tr("Create Route"));
    d->form->show();
}

void ColumbusDialogRoutes::showUpdateForm()
{
    QObject::connect(d->form, SIGNAL(finished(int)), this, SLOT(onUpdateFormFinished(int)));

    d->form->setWindowTitle(tr("Update Route"));
    d->form->show();
}

void ColumbusDialogRoutes::showRouteView()
{
    d->view->show();
}

void ColumbusDialogRoutes::showDeleteConfirmation()
{
    d->deleteconfirm->setText(tr("Delete Route \"") + "\"");
    d->deleteconfirm->show();
}

void ColumbusDialogRoutes::onRouteSelected(const QModelIndex &index)
{

}

void ColumbusDialogRoutes::onRouteClear()
{

}

void ColumbusDialogRoutes::onCreateFormFinished(int result)
{
    if(result != QDialog::Accepted) return;
}

void ColumbusDialogRoutes::onUpdateFormFinished(int result)
{
    if(result != QDialog::Accepted) return;
}

void ColumbusDialogRoutes::onDeleteFormFinished(int result)
{
    if(result != QDialog::Accepted) return;
}
