#include "ColumbusDialogAbout.h"

#include <QDesktopServices>

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogAboutPrivate
{
public:
    ColumbusDialogAboutPrivate();

    QFormLayout *form;

    QLabel      *email;
    QLabel      *website;

    QPushButton *help;
    QPushButton *donate;
};

ColumbusDialogAboutPrivate::ColumbusDialogAboutPrivate()
{ /* ... */ }

ColumbusDialogAbout::ColumbusDialogAbout(QWidget *parent)
    : ColumbusDialog(parent), d(new ColumbusDialogAboutPrivate)
{
    this->setWindowTitle(tr("About"));

    d->form = new QFormLayout(this);
    d->form->setLabelAlignment(Qt::AlignRight);

    this->addField(tr("Name"),    "Columbus Navigation Toolkit");
    this->addField(tr("Version"), QApplication::applicationVersion());
    this->addField(tr("Author"), "Tom Swindell");

    d->email = this->addField(tr("E-Mail"),  "t.swindell@rubyx.co.uk");
    d->website = this->addField(tr("Website"), "http://stage.rubyx.co.uk/columbus/");

    QPalette palette = this->palette();
    palette.setColor(this->foregroundRole(), palette.highlight().color());

    d->email->setPalette(palette);
    d->website->setPalette(palette);

    d->form->addRow("", new QLabel("", this));

    d->help = new QPushButton(tr("Help"), this);
    d->donate = new QPushButton(tr("Donate"), this);

    QHBoxLayout *hbox = new QHBoxLayout;

    hbox->addWidget(d->help);
    hbox->addWidget(d->donate);

    d->form->addRow(hbox);

    d->email->installEventFilter(this);
    d->website->installEventFilter(this);

    QObject::connect(d->help, SIGNAL(clicked()), this, SLOT(onHelpClicked()));
    QObject::connect(d->donate, SIGNAL(clicked()), this, SLOT(onDonateClicked()));
}

QLabel* ColumbusDialogAbout::addField(const QString &name, const QString &value)
{
    QLabel *lLabel = new QLabel(name, this);
    QLabel *lValue = new QLabel(value, this);

    QFont fLabel = lLabel->font();
    fLabel.setWeight(QFont::Bold);
    fLabel.setPointSize(18);

    QFont fValue = lValue->font();
    fValue.setPointSize(16);

    lLabel->setFont(fLabel);
    lValue->setFont(fValue);

    d->form->addRow(lLabel, lValue);

    return lValue;
}

bool ColumbusDialogAbout::eventFilter(QObject *object, QEvent *event)
{
    bool result = ColumbusDialog::eventFilter(object, event);

    if(event->type() != QEvent::MouseButtonRelease) return result;

    if(object == d->email)
    {
        if(!QDesktopServices::openUrl(QUrl("mailto:t.swindell@rubyx.co.uk?subject=Columbus%20Navigation%20Toolkit")))
        {
            qDebug() << "ColumbusDialogAbout: Failed to invoke email handler.";
            QMaemo5InformationBox::information(this->topLevelWidget(), tr("Operation Failed"), 4000);
        }
        else
        {
            qDebug() << "ColumbusDialogAbout: Successfully invoked email handler, notifying user.";
            QMaemo5InformationBox::information(this->topLevelWidget(), tr("Opening E-Mail"), 4000);
        }
    }
    else if(object == d->website)
    {
        if(!QDesktopServices::openUrl(QUrl("http://stage.rubyx.co.uk/columbus/")))
        {
            qDebug() << "ColumbusDialogAbout: Failed to invoke http handler.";
            QMaemo5InformationBox::information(this->topLevelWidget(), tr("Operation Failed"), 4000);
        }
        else
        {
            qDebug() << "ColumbusDialogAbout: Successfully invoked http handler, notifying user";
            QMaemo5InformationBox::information(this->topLevelWidget(), tr("Opening Webpage"), 4000);
        }
    }

    return result;
}

void ColumbusDialogAbout::onHelpClicked()
{
    qDebug() << "ColumbusDialogAbout: Opening documentation URL";
    QDesktopServices::openUrl(QUrl("http://stage.rubyx.co.uk/columbus/" + QApplication::applicationVersion() + "/doc/"));
    QMaemo5InformationBox::information(this->topLevelWidget(), tr("Opening Webpage"));
}

void ColumbusDialogAbout::onDonateClicked()
{
    qDebug() << "ColumbusDialogAbout: Opening donation URL";
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=ZPZRSLHYLHALN"));
    QMaemo5InformationBox::information(this->topLevelWidget(), tr("Opening Webpage"));
}
