#
# columbus.pro - Qt project file for Columbus Navigation Tookit application
#
TARGET       = columbus
TEMPLATE     = app

QT           = core gui dbus sql maemo5
CONFIG      += mobility
MOBILITY    += systeminfo location

INCLUDEPATH += ./src
LIBS        += -L/opt/usr/lib -lrxsupport -lcolumbus

DEFINES += RX_APPLICATION_NAME=\\\"columbus\\\"
DEFINES += RX_APPLICATION_VERSION=\\\"0.9.3\\\"

TARGET.CAPABILITY = Location

maemo5 {
    target.path         = /opt/usr/bin

    desktopicon.files   = columbus.png
    desktopicon.path    = /usr/share/icons/hicolor/64x64/apps

    desktopfile.files   = columbus.desktop
    desktopfile.path    = /usr/share/applications/hildon

    sudoersfile.files   = columbus.sudoers
    sudoersfile.path    = /etc/sudoers.d

    INSTALLS = target desktopicon desktopfile sudoersfile
}

RESOURCES += \
    resources.qrc

HEADERS += \
    src/ui/ApplicationView.h \
    src/ui/ApplicationViewSwitcher.h \
    src/ui/widgets/AbstractCompass.h \
    src/ui/widgets/CompassSlide.h \
    src/ui/widgets/CompassPrivate.h \
    src/ui/widgets/CompassDial.h \
    src/ui/widgets/SignalGraph.h \
    src/ui/widgets/AccuracyGraph.h \
    src/ui/widgets/SatelliteCompassDial.h \
    src/ui/widgets/TrackView.h \
    src/ui/widgets/SpeedGraph.h \
    src/ui/widgets/AltitudeProfileGraph.h \
    src/ui/ColumbusStatisticsView.h \
    src/ui/ColumbusStatusView.h \
    src/ui/ColumbusTrackView.h \
    src/ui/ColumbusDialogLogging.h \
    src/ui/ColumbusDialogOptions.h \
    src/ui/ColumbusDialogTools.h \
    src/ui/ColumbusDialogWaypoints.h \
    src/ui/MainWindow.h \
    src/ui/widgets/ColumbusDialog.h \
    src/ui/widgets/AbstractChart.h \
    src/config.h \
    src/ApplicationController.h \
    src/ui/widgets/WaypointListDelegate.h \
    src/ui/ColumbusDialogWaypointsForm.h \
    src/ui/ColumbusDialogWaypointsAverage.h \
    src/ui/ColumbusDialogWaypointsItemMenu.h \
    src/ui/ColumbusDialogAbout.h \
    src/ui/ColumbusDialogRoutes.h \
    src/ColumbusRouteModel.h \
    src/ui/widgets/RouteListDelegate.h \
    src/ui/ColumbusDialogRoutesForm.h \
    src/ui/ColumbusDialogRoutesView.h

SOURCES += \
    src/ui/ApplicationView.cpp \
    src/ui/ApplicationViewSwitcher.cpp \
    src/ui/widgets/CompassSlide.cpp \
    src/ui/widgets/CompassDial.cpp \
    src/ui/widgets/AbstractCompass.cpp \
    src/ui/widgets/SignalGraph.cpp \
    src/ui/widgets/AccuracyGraph.cpp \
    src/ui/widgets/SatelliteCompassDial.cpp \
    src/ui/widgets/TrackView.cpp \
    src/ui/widgets/SpeedGraph.cpp \
    src/ui/widgets/AltitudeProfileGraph.cpp \
    src/ui/ColumbusDialogWaypoints.cpp \
    src/ui/ColumbusStatisticsView.cpp \
    src/ui/ColumbusStatusView.cpp \
    src/ui/ColumbusTrackView.cpp \
    src/ui/ColumbusDialogLogging.cpp \
    src/ui/ColumbusDialogOptions.cpp \
    src/ui/ColumbusDialogTools.cpp \
    src/ui/MainWindow.cpp \
    src/main.cpp \
    src/ui/widgets/ColumbusDialog.cpp \
    src/ui/widgets/AbstractChart.cpp \
    src/ApplicationController.cpp \
    src/ui/widgets/WaypointListDelegate.cpp \
    src/ui/ColumbusDialogWaypointsForm.cpp \
    src/ui/ColumbusDialogWaypointsAverage.cpp \
    src/ui/ColumbusDialogWaypointsItemMenu.cpp \
    src/ui/ColumbusDialogAbout.cpp \
    src/ui/ColumbusDialogRoutes.cpp \
    src/ColumbusRouteModel.cpp \
    src/ui/widgets/RouteListDelegate.cpp \
    src/ui/ColumbusDialogRoutesForm.cpp \
    src/ui/ColumbusDialogRoutesView.cpp

OTHER_FILES += \
    columbus.sudoers \
    columbus.png \
    columbus.desktop
