#include "WaypointListDelegate.h"

#include <rx/columbus/ColumbusWaypointModel.h>

#include <QtGui>
#include <QtMaemo5>

class WaypointListDelegatePrivate
{
public:
    ColumbusModel *model;
};

WaypointListDelegate::WaypointListDelegate(ColumbusModel *model, QObject *parent)
    : QStyledItemDelegate(parent)
{
    this->d = new WaypointListDelegatePrivate;
    d->model = model;
}

WaypointListDelegate::~WaypointListDelegate()
{
    delete this->d;
}

void WaypointListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    ColumbusWaypointModel  *wpm       = (ColumbusWaypointModel*)index.model();
    ColumbusWaypoint        waypoint  = wpm->waypoint(index);
    QColor                  normColor = option.palette.foreground().color();
    QColor                  attrColor = option.palette.mid().color();

    QFont normal = QFont(painter->font());
    normal.setPointSize(18);

    QFont small = QFont(painter->font());
    small.setPointSize(14);

    QString name        = waypoint.name();
    QString distance    = QString("Distance: %1");
    QString azimuth     = QString::fromUtf8("Bearing: %1°");

    if(wpm->destination().isValid() && wpm->destination().row() == index.row())
    {
        normColor = option.palette.highlight().color();
        attrColor = option.palette.highlight().color();
    }

    if(d->model->datalog()->count() > 0)
    {
        QGeoCoordinate cCoord = d->model->currentPosition();
        QGeoCoordinate wCoord = waypoint.coordinate();

        distance = distance.arg(QString::number(ColumbusModel::convertDistanceToUnits(d->model->displayUnits(), cCoord.distanceTo(wCoord)), 'f', 2) + " " + d->model->distanceUnits());
        azimuth  = azimuth.arg(QString::number(cCoord.azimuthTo(wCoord), 'f', 2));
    }
    else
    {
        distance = distance.arg("-");
        azimuth  = azimuth.arg("-");
    }

    if(option.state & QStyle::State_On)
    {
        painter->fillRect(QRect(option.rect.x(), option.rect.y(), option.rect.width(), option.rect.height()), option.palette.highlight().color());
    }

    painter->setPen(QPen(normColor));
    painter->setFont(normal);

    QRect r1 = painter->boundingRect(option.rect.x(), option.rect.y(), 0, 0, 0, name);
    painter->setMatrix(QMatrix());
    painter->translate(5, option.rect.height() / 2 - r1.height() / 2);
    painter->drawText(r1, name);

    painter->setPen(QPen(attrColor));
    painter->setFont(small);

    QRect r2 = painter->boundingRect(option.rect.x(), option.rect.y(), 0, 0, 0, distance);
    painter->setMatrix(QMatrix());
    painter->translate(option.rect.width() - r2.width() - 5,
                       option.rect.height() / 2 - r2.height() - 2);
    painter->drawText(r2, distance);

    QRect r3 = painter->boundingRect(option.rect.x(), option.rect.y(), 0, 0, 0, azimuth);
    painter->setMatrix(QMatrix());
    painter->translate(option.rect.width() - r3.width() - 5,
                       option.rect.height() / 2 + 2);
    painter->drawText(r3, azimuth);

    painter->setMatrix(QMatrix());
}
