#include "ColumbusDialogWaypointsForm.h"

#include "config.h"

#include <rx/columbus/ColumbusWaypointModel.h>

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogWaypointsFormPrivate
{
public:
    QBoxLayout  *bbox;

    QLineEdit   *name;

    QStringListModel        *model;
    QMaemo5ValueButton      *format;
    QMaemo5ListPickSelector *selector;

    QLineEdit   *latitude;
    QLineEdit   *longitude;

    QPushButton *save;
};

ColumbusDialogWaypointsForm::ColumbusDialogWaypointsForm(QWidget *parent)
    : ColumbusDialog(parent)
{
    this->d = new ColumbusDialogWaypointsFormPrivate;
}

ColumbusDialogWaypointsForm::~ColumbusDialogWaypointsForm()
{
    delete this->d;
}

void ColumbusDialogWaypointsForm::setController(ApplicationController *controller)
{
    ColumbusDialog::setController(controller);

    if(controller != NULL)
    {
        this->setupUi();
    }
}

QString ColumbusDialogWaypointsForm::name() const
{
    return d->name->text();
}

QGeoCoordinate ColumbusDialogWaypointsForm::coordinate() const
{
    if(d->latitude->text().isEmpty() || d->longitude->text().isEmpty())
    {
        return QGeoCoordinate();
    }
    else
    {
        return QGeoCoordinate(d->latitude->text().toDouble(), d->longitude->text().toDouble());
    }
}

void ColumbusDialogWaypointsForm::setName(const QString &name)
{
    d->name->setText(name);
}

void ColumbusDialogWaypointsForm::setCoordinate(const QGeoCoordinate &coord)
{
    if(qIsNaN(coord.latitude()) || qIsNaN(coord.longitude()))
    {
        d->latitude->setText("");
        d->longitude->setText("");
    }
    else
    {
        d->latitude->setText(QString::number(coord.latitude()));
        d->longitude->setText(QString::number(coord.longitude()));
    }
}

void ColumbusDialogWaypointsForm::setupUi()
{
    QFormLayout *form = new QFormLayout();
    form->setLabelAlignment(Qt::AlignRight | Qt::AlignVCenter);

    d->bbox = new QBoxLayout(QBoxLayout::TopToBottom, this);

    d->name = new QLineEdit(this);
    d->latitude = new QLineEdit(this);
    d->longitude = new QLineEdit(this);

    d->latitude->setInputMethodHints(Qt::ImhFormattedNumbersOnly);
    d->longitude->setInputMethodHints(Qt::ImhFormattedNumbersOnly);

    form->addRow(tr("Name"), d->name);
    form->addRow(tr("Latitude"), d->latitude);
    form->addRow(tr("Longitude"), d->longitude);

    d->save = new QPushButton(tr("Save"));
    d->save->setFocus();

    d->bbox->addLayout(form);
    d->bbox->addWidget(d->save);

    QObject::connect(d->save, SIGNAL(clicked()), this, SLOT(accept()));
}

void ColumbusDialogWaypointsForm::accept()
{
    if(this->name().isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Enter waypoint name"));
        return;
    }

    if(qIsNaN(this->coordinate().latitude()) || qIsNaN(this->coordinate().longitude()))
    {
        QMaemo5InformationBox::information(this, tr("Enter valid coordinates"));
        return;
    }

    ColumbusDialog::accept();
}
