#include <rx/columbus/ColumbusController.h>

#include <QVBoxLayout>
#include "ColumbusDialogTools.h"

ColumbusDialogTools::ColumbusDialogTools(QWidget *parent)
    : ColumbusDialog(parent)
{
    new QVBoxLayout(this);
    this->setWindowTitle(tr("Tools"));
}

void ColumbusDialogTools::setController(ApplicationController *controller)
{
    ColumbusDialog::setController(controller);

    QList<QString> ids = controller->plugins()->plugins().keys();
    qSort(ids);

    foreach(QString id, ids)
    {
        ColumbusPluginInterface *plugin = controller->plugins()->plugins().value(id);
        QWidget *control = plugin->control();

        if(control != NULL)
        {
            control->setParent(this);
            if(control != NULL) this->layout()->addWidget(control);
        }
    }
}
