#include "ColumbusDialogLogging.h"

#include <rx/columbus/ColumbusController.h>
#include <rx/columbus/logging/FileLoggerConfig.h>

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogLoggingPrivate
{
public:
    FileLoggerConfig *config;

    QScrollArea *scrollarea;

    QCheckBox *isEnabled;
    QCheckBox *isRunOnStart;

    QMaemo5ValueButton *format;
    QMaemo5ListPickSelector *formatSelector;
};

ColumbusDialogLogging::ColumbusDialogLogging(QWidget *parent)
    : ColumbusDialog(parent)
{
    new QVBoxLayout(this);

    this->d = new ColumbusDialogLoggingPrivate;
    d->config = new FileLoggerConfig(this);
}

ColumbusDialogLogging::~ColumbusDialogLogging()
{
    delete this->d;
}

void ColumbusDialogLogging::setController(ApplicationController *controller)
{
    ColumbusDialog::setController(controller);
    if(this->layout()->isEmpty())
    {
        this->setupUi();
        this->loadConfig();
        this->updateUi();

        QObject::connect(this, SIGNAL(finished(int)), this, SLOT(saveConfig()));
    }
}

void ColumbusDialogLogging::setupUi()
{
    QStringList formatStrings;

    foreach(AbstractLoggingFormatter *formatter, this->controller()->logger()->formatters())
    {
        formatStrings.append(formatter->friendlyName());
    }

    qSort(formatStrings);

    QStringListModel *formatModel = new QStringListModel(formatStrings, this);
    d->formatSelector = new QMaemo5ListPickSelector(this);
    d->formatSelector->setModel(formatModel);

    d->isEnabled = new QCheckBox(tr("Enabled"), this);
    d->isRunOnStart = new QCheckBox(tr("Run on Startup"), this);

    d->format = new QMaemo5ValueButton(tr("Format"), this);
    d->format->setPickSelector(d->formatSelector);

    this->layout()->addWidget(d->isEnabled);
    this->layout()->addWidget(d->isRunOnStart);
    this->layout()->addWidget(d->format);

    this->setWindowTitle(tr("Logging"));

    QObject::connect(d->isEnabled, SIGNAL(toggled(bool)), this, SLOT(updateUi()));
}

void ColumbusDialogLogging::updateUi()
{
    qDebug() << "ColumbusDialogLogging: Performing UI update.";
    bool isEnabledChecked = d->isEnabled->isChecked();
    d->isRunOnStart->setEnabled(isEnabledChecked);
    d->format->setEnabled(isEnabledChecked);
}

void ColumbusDialogLogging::loadConfig()
{
    qDebug() << "ColumbusDialogLogging: Loading settings.";
    d->isEnabled->setChecked(d->config->isEnabled());
    d->isRunOnStart->setChecked(d->config->isRunOnStartup());
    d->formatSelector->setCurrentIndex(0);
}

void ColumbusDialogLogging::saveConfig()
{
    qDebug() << "ColumbusDialogLogging: Saving settings.";
    d->config->setEnabled(d->isEnabled->isChecked());
    d->config->setRunOnStartup(d->isRunOnStart->isChecked());

    foreach(AbstractLoggingFormatter *formatter, this->controller()->logger()->formatters().values())
    {
        if(formatter->friendlyName() == d->format->valueText())
        {
            d->config->setFormatId(formatter->id());
            break;
        }
    }

    this->controller()->logger()->setupLogging();
}
