#include "CompassSlide.h"
#include "CompassPrivate.h"

class CompassSlidePrivate
{
public:
    CompassSlide::DisplayMode displaymode;
};

CompassSlide::CompassSlide(QWidget *parent)
    : AbstractCompass(parent)
{
    this->d = new CompassSlidePrivate;
    d->displaymode = CompassSlide::TopAndBottom;

    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);
}

CompassSlide::CompassSlide(DisplayMode mode, QWidget *parent)
    : AbstractCompass(parent)
{
    d->displaymode     = mode;

    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);
}

int CompassSlide::heightForWidth(int width) const
{
    return width / (100.0 / 30.0);
}

CompassSlide::DisplayMode CompassSlide::displayMode() const
{
    return d->displaymode;
}

void CompassSlide::setDisplayMode(DisplayMode mode)
{
    d->displaymode = mode;
    this->update();
}

void CompassSlide::paintEvent(QPaintEvent*)
{
    static const QPen none (Qt::black, 0.00f);

    QPainter    *painter = new QPainter(this);

    int         width   = this->width();
    int         height  = this->height();

    // Setup viewport
    painter->setRenderHint(QPainter::Antialiasing, true);
    painter->setViewport(0, 0, width, height);
    painter->setWindow(-50, -15, 100, 30);

    // Draw rule.
    this->draw(painter);

    painter->setPen(none);
    painter->setBrush(this->palette().highlight());

    if(this->displayMode() == CompassSlide::Top || this->displayMode() == CompassSlide::TopAndBottom)
    {
        // Draw top chevron.
        painter->setMatrix(QMatrix());
        painter->translate(QPoint(0, -12));
        painter->drawPolygon(QPolygon(3, &HeadingMarker[0][0]));
    }

    if(this->displayMode() == CompassSlide::Bottom || this->displayMode() == CompassSlide::TopAndBottom)
    {
        // Invert and draw bottom chevron.
        painter->setMatrix(QMatrix());
        painter->translate(QPoint(0, 12));
        painter->scale(1, -1);
        painter->drawPolygon(QPolygon(3, &HeadingMarker[0][0]));
    }

    delete painter;
}

void CompassSlide::draw(QPainter *painter)
{
    static const QFont  f5pt    ("Times", 5, QFont::Normal);
    static const QFont  f7pt    ("Times", 7, QFont::Normal);

    const QPen   p250    (this->palette().foreground(),  0.250f);

    int s = this->heading() - (100 / 2);

    painter->setPen(p250);
    painter->setMatrix(QMatrix());

    if(this->displayMode() == CompassSlide::Top || this->displayMode() == CompassSlide::TopAndBottom)
    {
        painter->drawLine(QPoint(-(100 / 2), -10), QPoint(+(100 / 2), -10));
    }

    if(this->displayMode() == CompassSlide::Bottom || this->displayMode() == CompassSlide::TopAndBottom)
    {
        painter->drawLine(QPoint(-(100 / 2), +10), QPoint(+(100 / 2), +10));
    }

    painter->setPen(p250);
    painter->setBrush(this->palette().foreground());

    for(int i = 0; i < 100; i++)
    {
        float    x  = -(100 / 2) + i;

        float   y1  =  10;
        float   y2  =  y1 - 1.0f;

        int      d  =  s + i;

        if(d < 0)
        {
            d = d + 360;
        }

        if(d == 360)
        {
            d = 0;
        }

        if(d % 90 == 0)
        {
            const char  *point  = CompassPoints[d / 45];

            painter->setFont(f7pt);
            painter->drawText(painter->boundingRect(x, 0, 0, 0, Qt::AlignHCenter | Qt::AlignVCenter, point),
                              Qt::AlignHCenter | Qt::AlignVCenter, point);

            y2 -= 5;
        }
        else if (d % 45 == 0)
        {
            const char  *point  = CompassPoints[d / 45];

            painter->setFont(f5pt);
            painter->drawText(painter->boundingRect(x, 0, 0, 0, Qt::AlignHCenter | Qt::AlignVCenter, point),
                              Qt::AlignHCenter | Qt::AlignVCenter, point);

            y2 -= 4;
        }
        else if (d % 5 == 0)
        {
            y2 -= 2;
        }

        if(this->displayMode() == CompassSlide::Top || this->displayMode() == CompassSlide::TopAndBottom)
        {
            painter->drawLine(QPointF(x, -y1), QPointF(x, -y2));
        }

        if(this->displayMode() == CompassSlide::Bottom || this->displayMode() == CompassSlide::TopAndBottom)
        {
            painter->drawLine(QPointF(x, y1), QPointF(x, y2));
        }
    }
}
