#ifndef APPLICATIONVIEWSWITCHER_H
#define APPLICATIONVIEWSWITCHER_H

#include <rx/widgets/DraggableViewArea.h>
#include "ApplicationView.h"

class ApplicationViewSwitcherPrivate;

class ApplicationViewSwitcher : public QWidget
{
    Q_OBJECT

public:
    explicit                 ApplicationViewSwitcher    (QWidget *parent = 0);
                            ~ApplicationViewSwitcher    ();

    QList<ApplicationView*>  views                      () const;
    void                     addView                    (ApplicationView *view);

signals:
    void                     viewChanged                (int view);
    void                     viewChanged                (QWidget *view);

public slots:
    void                     slideTo                    (int view);
    void                     slideTo                    (ApplicationView *view);

private:
    ApplicationViewSwitcherPrivate *d;
};

#endif // APPLICATIONVIEWSWITCHER_H
