#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <QWidget>

#include <rx/columbus/ColumbusModel.h>

class TrackViewPrivate;

class TrackView : public QWidget
{
    Q_OBJECT

    Q_PROPERTY(ColumbusModel* model READ model WRITE setModel NOTIFY modelUpdated)
    Q_PROPERTY(qreal zoom READ zoom WRITE setZoom NOTIFY zoomUpdated)
    Q_PROPERTY(qreal rotation READ rotation WRITE setRotation NOTIFY rotationUpdated)
    Q_PROPERTY(QPointF position READ position WRITE setPosition NOTIFY positionUpdated)

public:
    explicit TrackView(QWidget *parent = 0);
            ~TrackView();

    ColumbusModel* model();

    qreal zoom() const;
    qreal rotation() const;
    QPointF position() const;

signals:
    void modelUpdated(ColumbusModel *model);

    void zoomUpdated(qreal zoom);
    void rotationUpdated(qreal rotation);
    void positionUpdated(QPointF position);

public slots:
    void setModel(ColumbusModel *model);

    void setZoom(qreal zoom);
    void setRotation(double rotation);
    void setPosition(QPointF position);

protected:
    void         paintEvent     (QPaintEvent *event);

    TrackViewPrivate *d;
};

#endif // TRACKVIEW_H
