#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "widgets/ColumbusDialog.h"

#include "ApplicationViewSwitcher.h"

#include <rx/columbus/ColumbusController.h>

#include <QMainWindow>

#include <QActionGroup>
#include <QSystemScreenSaver>
#include <QParallelAnimationGroup>

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit     MainWindow     (QWidget *parent = 0);

    void         initialize     (ColumbusController *controller);

signals:
    void         onLandscape    ();
    void         onPortrait     ();

    void         uiSuspended    ();
    void         uiResumed      ();

public slots:
    void         setOrientationAuto         (bool on = true);
    void         setOrientationLandscape    (bool on = true);
    void         setOrientationPortrait     (bool on = true);

    void         setScreenSaverInhibit      (bool on = true);

    void         showFullScreenControls     ();
    void         hideFullScreenControls     ();

private slots:
    void         resized    ();

    void         suspend    ();
    void         resume     ();

    void         onScreenLockSignal     (const QString &state);

    void         onViewChanged          (int view);
    void         onViewsActionSelected  (QAction *action);

    void         onConfigUpdated        (const QString &key, QVariant value);

protected:
    void         setupX11Keys();

private:
    void         setupMenu      ();
    void         setupViews     ();
    void         setupPalettes  ();

    bool         eventFilter    (QObject *object, QEvent *event);

    // Reference to application controller instance.
    ColumbusController   *m_Controller;
    ColumbusController   *m_ControllerSuspended;

    // Current screen lock state
    QString m_ScreenLockState;

    // Reference to object for inhibiting screen lock.
    QSystemScreenSaver      *m_ScreenSaver;

    // Custom palettes.
    QPalette         m_Theme;

    // Menu group for selecting views.
    QActionGroup    *m_ViewsActionGroup;

    // Application dialogs.
    ColumbusDialog    *m_WaypointsDialog;
    ColumbusDialog    *m_LoggingDialog;
    ColumbusDialog    *m_OptionsDialog;
    ColumbusDialog    *m_ToolsDialog;

    // View manager/switcher widget.
    ApplicationViewSwitcher *m_ApplicationViewSwitcher;

    // Animation for fullscreen controls.
    QParallelAnimationGroup *m_ControlsAnimationGroup;
};

#endif // MAINWINDOW_H
