#include <rx/columbus/ColumbusController.h>

#include <QVBoxLayout>
#include <QCheckBox>
#include <QScrollArea>
#include <QStringListModel>

#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

#include "ColumbusDialogOptions.h"

class ColumbusDialogOptionsPrivate
{
public:
    QLayout     *layout;
};

ColumbusDialogOptions::ColumbusDialogOptions(QWidget *parent)
    : ColumbusDialog(parent)
{
    this->d = new ColumbusDialogOptionsPrivate;

    QScrollArea *scrollarea = new QScrollArea(this);
    scrollarea->setWidgetResizable(true);
    scrollarea->setWidget(new QWidget(this));

    d->layout = new QVBoxLayout(scrollarea->widget());

    new QVBoxLayout(this);
    this->layout()->addWidget(scrollarea);

    this->setWindowTitle(tr("Options"));
}

ColumbusDialogOptions::~ColumbusDialogOptions()
{
    delete this->d;
}

void ColumbusDialogOptions::setController(ColumbusController *controller)
{
    ColumbusDialog::setController(controller);

    if(d->layout->isEmpty())
    {
        foreach(QString key, controller->config()->keys())
        {
            if(controller->config()->isToggle(key))
            {
                this->addToggle(key);
            }
            else
            {
                this->addOption(key);
            }
        }
    }
}

void ColumbusDialogOptions::addToggle(const QString &key)
{
    QCheckBox *checkbox = new QCheckBox(this->controller()->config()->label(key), this);

    checkbox->setChecked(this->controller()->config()->value(key).toBool());
    checkbox->setProperty("configuration-key", key);

    QObject::connect(checkbox, SIGNAL(toggled(bool)), this, SLOT(onToggleChanged(bool)));
    d->layout->addWidget(checkbox);
}

void ColumbusDialogOptions::addOption(const QString &key)
{
    QStringListModel        *model      = new QStringListModel(this->controller()->config()->options(key), this);
    QMaemo5ValueButton      *button     = new QMaemo5ValueButton(this->controller()->config()->label(key), this);
    QMaemo5ListPickSelector *selector   = new QMaemo5ListPickSelector(this);

    selector->setModel(model);
    selector->setProperty("configuration-key", key);
    selector->setCurrentIndex(this->controller()->config()->valueIndex(key));

    button->setPickSelector(selector);
    button->setValueText(selector->currentValueText());
    //button->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);

    QObject::connect(selector, SIGNAL(selected(QString)), this, SLOT(onOptionChanged(QString)));
    d->layout->addWidget(button);
}

void ColumbusDialogOptions::onToggleChanged(bool value)
{
    QCheckBox *checkbox = qobject_cast<QCheckBox*>(QObject::sender());
    Q_ASSERT(checkbox);
    QString key = checkbox->property("configuration-key").toString();
    this->controller()->config()->setValue(key, value);
}

void ColumbusDialogOptions::onOptionChanged(const QString &value)
{
    QMaemo5ListPickSelector *selector = qobject_cast<QMaemo5ListPickSelector*>(QObject::sender());
    Q_ASSERT(selector);
    QString key = selector->property("configuration-key").toString();
    this->controller()->config()->setValue(key, value);
}

