#ifndef SCROLL_AREA_H
#define SCROLL_AREA_H

#include <QWidget>
#include <QMouseEvent>
#include <QPropertyAnimation>

class DraggableViewAreaPrivate;

class DraggableViewArea: public QWidget
{
    Q_OBJECT

public:
    explicit     DraggableViewArea  (Qt::Orientation orientation, QWidget *parent = 0);
                ~DraggableViewArea  ();

signals:
    void         slidTo             (int index);
    void         slidTo             (QWidget *widget);

public slots:
    void         addWidget          (QWidget *widget);

    void         jumpTo             (int index);
    void         jumpTo             (QWidget *widget);

    void         slideTo            (int index);
    void         slideTo            (QWidget *widget);

protected slots:
    void         animationFinished  ();

protected:
    bool         eventFilter        (QObject *object, QEvent *event);

    void         mousePressEvent    (QMouseEvent *event);
    void         mouseMoveEvent     (QMouseEvent *event);
    void         mouseReleaseEvent  (QMouseEvent *event);

    DraggableViewAreaPrivate    *d;
};

class HDraggableViewArea : public DraggableViewArea {
public:
    explicit HDraggableViewArea(QWidget *parent = 0) : DraggableViewArea(Qt::Horizontal, parent) { /* ... */ }
            ~HDraggableViewArea() {}
};

class VDraggableViewArea : public DraggableViewArea {
public:
    explicit VDraggableViewArea(QWidget *parent = 0) : DraggableViewArea(Qt::Vertical, parent) { /* ... */ }
            ~VDraggableViewArea() {}
};

#endif
