#include "AbstractCompass.h"

class AbstractCompassPrivate
{
public:
    double heading;
    double bearing;
};

AbstractCompass::AbstractCompass(QWidget *parent)
    : QWidget(parent)
{
    this->d = new AbstractCompassPrivate;
    d->heading = 0.0f;
    d->bearing = 0.0f;
}

AbstractCompass::~AbstractCompass()
{
    delete this->d;
}

double AbstractCompass::heading() const
{
    return d->heading;
}

double AbstractCompass::bearing() const
{
    return d->bearing;
}

void AbstractCompass::setHeading(double heading)
{
    d->heading = heading;
    this->update();

    emit this->headingChanged(heading);
}

void AbstractCompass::setBearing(double bearing)
{
    d->bearing = bearing;
    this->update();

    emit this->bearingChanged(bearing);
}
