#include "FileDataLoggerConfig.h"

#include <QSettings>

#define CONFIG_KEY_FILE_LOGGER_IS_ENABLED           "/prefs/logging/enabled"
#define CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP    "/prefs/logging/on-startup"
#define CONFIG_KEY_FILE_LOGGER_FORMAT               "/prefs/logging/format"

FileDataLoggerConfig::FileDataLoggerConfig(QObject *parent) : QObject(parent) {/* ... */}

bool FileDataLoggerConfig::isEnabled() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_IS_ENABLED, false).toBool();
}

bool FileDataLoggerConfig::isRunOnStartup() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP, false).toBool();
}

QString FileDataLoggerConfig::formatId() const
{
    return QSettings().value(CONFIG_KEY_FILE_LOGGER_FORMAT, "nmea").toString();
}

void FileDataLoggerConfig::setEnabled(bool isEnabled)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_IS_ENABLED, isEnabled);
}

void FileDataLoggerConfig::setRunOnStartup(bool isRunOnStartup)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_IS_RUN_ON_STARTUP, isRunOnStartup);
}

void FileDataLoggerConfig::setFormatId(const QString &formatId)
{
    QSettings().setValue(CONFIG_KEY_FILE_LOGGER_FORMAT, formatId);
}
