#include "FileDataLogger.h"

#include <QDebug>

#include <QDir>
#include <QFile>
#include <QDate>

#define MAX_LOGFILE_SIZE_BYTES (1024 * 1024 * 5)

class FileDataLoggerPrivate
{
public:
    QString logdir;
    QString filename;

    QFile *file;
    quint64 bytesOut;
};

FileDataLogger::FileDataLogger(const QString &logdir, const QString &filename, QObject *parent)
    : AbstractDataLogger(parent)
{
    qDebug() << "FileDataLogger: ctor()";
    this->d = new FileDataLoggerPrivate;
    d->logdir = logdir;
    d->filename = filename;
    d->bytesOut = 0;
    d->file = NULL;
}

FileDataLogger::~FileDataLogger()
{
    qDebug() << "FileDataLogger: dtor()";

    if(d->file != NULL)
    {
        d->file->close();
    }

    delete this->d;
}

void FileDataLogger::onDataReady(const QByteArray &data)
{
    if(d->file == NULL)
    {
        int i = 1;
        QString filepath = QDir(d->logdir).absoluteFilePath(QDate::currentDate().toString(d->filename + "-%1.log").arg(i));

        while(QFileInfo(filepath).size() > MAX_LOGFILE_SIZE_BYTES)
        {
            filepath = QDir(d->logdir).absoluteFilePath(QDate::currentDate().toString(d->filename + "-%1.log").arg(i));
            i++;
        }

        qDebug() << "FileDataLogger: Using logfile:" << filepath;

        d->file = new QFile(filepath, this);
        d->file->open(QFile::Append | QFile::WriteOnly);
    }

    d->bytesOut += d->file->write(data);
    d->file->flush();

    if(d->bytesOut >= MAX_LOGFILE_SIZE_BYTES)
    {
        d->file->close();
        delete d->file;
        d->file = NULL;
        d->bytesOut = 0;
    }
}
