#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <QHash>
#include <QObject>

#include "ColumbusPlugin.h"

class ApplicationController;
class PluginManagerPrivate;

class PluginManager : public QObject
{
    Q_OBJECT

public:
    explicit PluginManager  (QObject *parent = 0);
            ~PluginManager  ();

    void     initialize     (ApplicationController *controller);
    void     loadPlugins    ();

    ApplicationController*           controller () const;
    QHash<QString,ColumbusPlugin*>   plugins    () const;

protected:
    bool registerPlugin     (ColumbusPlugin *plugin);
    void unregisterPlugin   (const QString &pluginId);

private:
    PluginManagerPrivate *d;
};

#endif // PLUGINMANAGER_H
