#ifndef USBSERIALCONFIG_H
#define USBSERIALCONFIG_H

#include <QObject>

class USBSerialConfig : public QObject
{
    Q_OBJECT

public:
    explicit USBSerialConfig(QObject *parent = 0);

    bool isEnabled() const;
    bool isRunOnStartup() const;
    int  portNumber() const;
    QString formatId() const;

public slots:
    void setEnabled(bool on = true);
    void setRunOnStartup(bool on = true);
    void setPortNumber(int number = 0);
    void setFormatId(const QString &formatId);
};

#endif // USBSERIALCONFIG_H
