#include <QVBoxLayout>
#include "ColumbusDialogTools.h"

ColumbusDialogTools::ColumbusDialogTools(QWidget *parent)
    : Maemo5Dialog(parent)
{
    new QVBoxLayout(this);
    this->setWindowTitle(tr("Tools"));
}

void ColumbusDialogTools::setController(ApplicationController *controller)
{
    QList<QString> ids = controller->plugins()->plugins().keys();
    qSort(ids);

    foreach(QString id, ids)
    {
        ColumbusPlugin  *plugin     = controller->plugins()->plugins().value(id);
        QWidget         *control    = plugin->control();
        control->setParent(this);
        if(control != NULL) this->layout()->addWidget(control);
    }
}

QMaemo5ValueButton* ColumbusDialogTools::addPluginButton(const QString &label, const QString &value)
{
    QMaemo5ValueButton *button = new QMaemo5ValueButton(label, this);
    button->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    button->setValueText(value);
    this->layout()->addWidget(button);
    return button;
}
