#include <QVBoxLayout>
#include "ApplicationViewSwitcher.h"

class ApplicationViewSwitcherPrivate
{
public:
    QList<ApplicationView*>      views;
    DraggableViewArea           *draggableArea;
};

ApplicationViewSwitcher::ApplicationViewSwitcher(QWidget *parent)
    : QWidget(parent)
{
    this->d = new ApplicationViewSwitcherPrivate;

    new QVBoxLayout(this);
    d->draggableArea = new HDraggableViewArea(this);
    this->layout()->addWidget(d->draggableArea);

    QObject::connect(d->draggableArea, SIGNAL(slidTo(int)), this, SIGNAL(viewChanged(int)));
    QObject::connect(d->draggableArea, SIGNAL(slidTo(QWidget*)), this, SIGNAL(viewChanged(QWidget*)));
}

ApplicationViewSwitcher::~ApplicationViewSwitcher()
{
    delete this->d;
}

QList<ApplicationView*> ApplicationViewSwitcher::views() const
{
    return d->views;
}

void ApplicationViewSwitcher::addView(ApplicationView *view)
{
    d->views.append(view);
    d->draggableArea->addWidget(view);
}

void ApplicationViewSwitcher::slideTo(int view)
{
    d->draggableArea->slideTo(view);
}

void ApplicationViewSwitcher::slideTo(ApplicationView *view)
{
    d->draggableArea->slideTo(view);
}
