#ifndef SERIALPORT_H
#define SERIALPORT_H

#include <QIODevice>

class SerialPortPrivate;

class SerialPort : public QIODevice
{
    Q_OBJECT

public:
    explicit SerialPort(QObject *parent = 0);
            ~SerialPort();

    QString deviceName() const;

    bool open(const QString &deviceName, OpenMode mode);
    void close();

    qint64 readData(char *data, qint64 maxlen);
    qint64 writeData(const char *data, qint64 len);

private:
    SerialPortPrivate *d;
};

#endif // SERIALPORT_H
