#ifndef SERVICEPERFORMERFACTORY_H
#define SERVICEPERFORMERFACTORY_H

#include "LoggingManager.h"
#include "ServicePerformer.h"

#include <QObject>

class ServicePerformerFactoryPrivate;

class ServicePerformerFactory : public QObject
{
    Q_OBJECT

public:
    explicit ServicePerformerFactory(AbstractDataFormatter *formatter, LoggingManager *manager, QObject *parent = 0);

    ServicePerformer* createInstance(QIODevice *io, QObject *parent);
    void              destroyInstance(ServicePerformer *performer);

private:
    ServicePerformerFactoryPrivate *d;
};

#endif // SERVICEPERFORMERFACTORY_H
