#ifndef ABSTRACTCOMPASS_H
#define ABSTRACTCOMPASS_H

#include <QWidget>

class AbstractCompassPrivate;

class AbstractCompass : public QWidget
{
    Q_OBJECT

    Q_PROPERTY(double heading READ heading WRITE setHeading)
    Q_PROPERTY(double bearing READ bearing WRITE setBearing)

public:
    explicit     AbstractCompass    (QWidget *parent = 0);
                ~AbstractCompass    ();

    double       heading            () const;
    double       bearing            () const;

signals:
    void         headingChanged     (double heading);
    void         bearingChanged     (double bearing);

public slots:
    void         setHeading         (double heading);
    void         setBearing         (double bearing);

protected:
    virtual void paintEvent         (QPaintEvent *event) = 0;

    AbstractCompassPrivate *d;
};

#endif // ABSTRACTCOMPASS_H
