#ifndef ABSTRACTDATAFORMATTER_H
#define ABSTRACTDATAFORMATTER_H

#include <QList>
#include <QObject>

#include <QGeoPositionInfo>
#include <QGeoSatelliteInfo>

QTM_USE_NAMESPACE

class AbstractDataFormatter : public QObject
{
    Q_OBJECT

public:
    explicit AbstractDataFormatter  (QObject *parent = 0) : QObject(parent) {/* ... */}
    virtual ~AbstractDataFormatter  () {};

    virtual QString id() const = 0;
    virtual QString friendlyName() const = 0;

signals:
    void dataReady(const QByteArray &data);

public slots:
    virtual void onPositionUpdate(const QGeoPositionInfo &position) = 0;

    virtual void onSatellitesInUse(const QList<QGeoSatelliteInfo> &satellites) = 0;
    virtual void onSatellitesInView(const QList<QGeoSatelliteInfo> &satellites) = 0;
};

#endif // ABSTRACTDATAFORMATTER_H
