#ifndef APPLICATIONCONTROLLER_H
#define APPLICATIONCONTROLLER_H

#include "ConfigManager.h"
#include "PluginManager.h"
#include "LoggingManager.h"

#include "data/TripModel.h"

#include <QList>
#include <QObject>

#include <QGeoPositionInfo>
#include <QGeoSatelliteInfo>

QTM_USE_NAMESPACE

class ApplicationControllerPrivate;

class ApplicationController : public QObject
{
    Q_OBJECT

public:
    explicit ApplicationController(QObject *parent = 0);
            ~ApplicationController();

    TripModel*       tripModel  () const;

    ConfigManager*   config     () const;
    PluginManager*   plugins    () const;
    LoggingManager*  logger     () const;

signals:
    void positionUpdated            (const QGeoPositionInfo &position);

    void satellitesInViewUpdated    (const QList<QGeoSatelliteInfo> &satellites);
    void satellitesInUseUpdated     (const QList<QGeoSatelliteInfo> &satellites);

protected slots:
    void onConfigUpdated            (const QString &key, QVariant value);
    void onPositionUpdated          (const QGeoPositionInfo &position);

protected:
    void setupConfig                ();

private:
    ApplicationControllerPrivate *d;
};

#endif // APPLICATIONCONTROLLER_H
