#ifndef USBSERIALPLUGIN_H
#define USBSERIALPLUGIN_H

#include <rx/columbus/ColumbusPluginManager.h>

class USBSerialPluginPrivate;

class USBSerialPlugin : public QObject, public ColumbusPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(ColumbusPluginInterface)

public:
    explicit USBSerialPlugin(QObject *parent = 0);
            ~USBSerialPlugin();

    QString id() const;
    QString version() const;
    QString friendlyName() const;

    QWidget* control();

    bool initialize(PluginManager *manager);

protected slots:
    void enablePhonetBridge();
    void disablePhonetBridge();

    bool startup();
    void shutdown();

    void onDialogFinished();

private:
    USBSerialPluginPrivate *d;
};

#endif // USBSERIALPLUGIN_H
