#include "USBSerialOptionsDialog.h"

#include <QtGui>
#include <QtMaemo5>

class USBSerialOptionsDialogPrivate
{
public:
    USBSerialConfig *config;
    LoggingManager *logger;

    QScrollArea *scrollarea;

    QCheckBox *isEnabled;
    QCheckBox *isRunOnStartup;

    QMaemo5ValueButton *port;
    QMaemo5ListPickSelector *portSelector;

    QMaemo5ValueButton *format;
    QMaemo5ListPickSelector *formatSelector;
};

USBSerialOptionsDialog::USBSerialOptionsDialog(USBSerialConfig *config, LoggingManager *logger, QWidget *parent)
    : Maemo5Dialog(parent)
{
    this->d = new USBSerialOptionsDialogPrivate;

    d->config = config;
    d->logger = logger;
    d->scrollarea = NULL;
    d->isEnabled = NULL;
    d->isRunOnStartup = NULL;
    d->port = NULL;
    d->portSelector = NULL;
    d->format = NULL;
    d->formatSelector = NULL;

    new QVBoxLayout(this);
    this->setWindowTitle(tr("USB Serial Profile"));

    this->setupUi();
    this->loadConfig();
    this->updateUi();

    QObject::connect(this, SIGNAL(finished(int)), this, SLOT(saveConfig()));
}

USBSerialOptionsDialog::~USBSerialOptionsDialog()
{
    delete this->d;
}

void USBSerialOptionsDialog::setupUi()
{
    QStringList pStrings = QStringList() << "ttyGS0" << "ttyGS1" << "ttyGS2";
    QStringList fStrings;

    foreach(AbstractLoggingFormatter *formatter, d->logger->formatters())
    {
        fStrings.append(formatter->friendlyName());
    }

    qSort(fStrings);

    QStringListModel *pModel = new QStringListModel(pStrings, this);
    QStringListModel *fModel = new QStringListModel(fStrings, this);

    d->scrollarea = new QScrollArea(this);
    d->scrollarea->setWidgetResizable(true);
    d->scrollarea->setWidget(new QWidget(this));

    QVBoxLayout *vbox = new QVBoxLayout(d->scrollarea->widget());

    d->isEnabled = new QCheckBox(tr("Enabled"), this);
    d->isRunOnStartup = new QCheckBox(tr("Run on Startup"), this);

    d->portSelector = new QMaemo5ListPickSelector(this);
    d->portSelector->setModel(pModel);

    d->port = new QMaemo5ValueButton(tr("Port"), this);
    //d->port->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    d->port->setPickSelector(d->portSelector);

    d->formatSelector = new QMaemo5ListPickSelector(this);
    d->formatSelector->setModel(fModel);

    d->format = new QMaemo5ValueButton(tr("Format"), this);
    //d->format->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    d->format->setPickSelector(d->formatSelector);

    vbox->addWidget(d->isEnabled);
    vbox->addWidget(d->isRunOnStartup);
    vbox->addWidget(d->port);
    vbox->addWidget(d->format);

    this->layout()->addWidget(d->scrollarea);

    QObject::connect(d->isEnabled, SIGNAL(toggled(bool)), this, SLOT(updateUi()));
}

void USBSerialOptionsDialog::updateUi()
{
    qDebug() << "USBSerialOptionsDialog: Performing UI update.";
    d->isRunOnStartup->setEnabled(d->isEnabled->isChecked());
    d->port->setEnabled(d->isEnabled->isChecked());
    d->format->setEnabled(d->isEnabled->isChecked());
}

void USBSerialOptionsDialog::loadConfig()
{
    qDebug() << "USBSerialOptionsDialog: Loading settings.";
    d->isEnabled->setChecked(d->config->isEnabled() && d->config->isRunOnStartup());
    d->isRunOnStartup->setChecked(d->config->isRunOnStartup());
    d->portSelector->setCurrentIndex(d->config->portNumber());
    d->formatSelector->setCurrentIndex(0);
}

void USBSerialOptionsDialog::saveConfig()
{
    qDebug() << "USBSerialOptionsDialog: Saving settings.";
    d->config->setEnabled(d->isEnabled->isChecked());
    d->config->setRunOnStartup(d->isRunOnStartup->isChecked());
    d->config->setPortNumber(d->portSelector->currentIndex());

    foreach(AbstractLoggingFormatter *formatter, d->logger->formatters().values())
    {
        if(formatter->friendlyName() == d->format->valueText())
        {
            d->config->setFormatId(formatter->id());
            break;
        }
    }
}
