#ifndef BLUETOOTHSOCKET_H
#define BLUETOOTHSOCKET_H

#include <QIODevice>

class BluetoothSocketPrivate;

class BluetoothSocket : public QIODevice
{
    Q_OBJECT

public:
    explicit BluetoothSocket(QObject *parent = 0);
             BluetoothSocket(int fd, QObject *parent = 0);
            ~BluetoothSocket();

     quint16 channel() const;

     QString peerAddress() const;
     quint16 peerChannel() const;

    bool listen(quint16 channel);
    bool listen(const QString &bdaddr, quint16 channel);

    BluetoothSocket* nextPendingConnection();

    bool connectToHost(const QString &bdaddr, quint16 channel);

    void close();

signals:
    void connected();
    void disconnected();

    void newConnection();

protected:
    qint64 readData(char *data, qint64 maxlen);
    qint64 writeData(const char *data, qint64 len);

protected slots:
    void onReadNotify();
    void onWriteNotify();

private:
    bool createSocket();

    BluetoothSocketPrivate *d;
};

#endif // BLUETOOTHSOCKET_H
