/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Authored By Matthew Allum  <mallum@openedhand.com>
 *
 * Copyright (C) 2006 OpenedHand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#ifndef __CLUTTER_H__
#define __CLUTTER_H__

#define __CLUTTER_H_INSIDE__

#include "clutter-deprecated.h"

#include "clutter-action.h"
#include "clutter-actor.h"
#include "clutter-actor-meta.h"
#include "clutter-align-constraint.h"
#include "clutter-alpha.h"
#include "clutter-animatable.h"
#include "clutter-animation.h"
#include "clutter-animator.h"
#include "clutter-backend.h"
#include "clutter-behaviour-depth.h"
#include "clutter-behaviour-ellipse.h"
#include "clutter-behaviour.h"
#include "clutter-behaviour-opacity.h"
#include "clutter-behaviour-path.h"
#include "clutter-behaviour-rotate.h"
#include "clutter-behaviour-scale.h"
#include "clutter-bind-constraint.h"
#include "clutter-binding-pool.h"
#include "clutter-bin-layout.h"
#include "clutter-blur-effect.h"
#include "clutter-box.h"
#include "clutter-box-layout.h"
#include "clutter-cairo-texture.h"
#include "clutter-child-meta.h"
#include "clutter-click-action.h"
#include "clutter-clone.h"
#include "clutter-color.h"
#include "clutter-colorize-effect.h"
#include "clutter-constraint.h"
#include "clutter-container.h"
#include "clutter-desaturate-effect.h"
#include "clutter-device-manager.h"
#include "clutter-drag-action.h"
#include "clutter-effect.h"
#include "clutter-event.h"
#include "clutter-feature.h"
#include "clutter-fixed-layout.h"
#include "clutter-flow-layout.h"
#include "clutter-frame-source.h"
#include "clutter-group.h"
#include "clutter-input-device.h"
#include "clutter-interval.h"
#include "clutter-keysyms.h" 
#include "clutter-layout-manager.h"
#include "clutter-layout-meta.h"
#include "clutter-list-model.h"
#include "clutter-main.h"
#include "clutter-media.h"
#include "clutter-model.h"
#include "clutter-offscreen-effect.h"
#include "clutter-path.h"
#include "clutter-rectangle.h"
#include "clutter-score.h"
#include "clutter-scriptable.h"
#include "clutter-script.h"
#include "clutter-shader.h"
#include "clutter-shader-effect.h"
#include "clutter-shader-types.h"
#include "clutter-stage.h"
#include "clutter-stage-manager.h"
#include "clutter-stage-window.h"
#include "clutter-state.h"
#include "clutter-texture.h"
#include "clutter-text.h"
#include "clutter-timeline.h"
#include "clutter-timeout-pool.h"
#include "clutter-types.h"
#include "clutter-units.h"
#include "clutter-util.h"
#include "clutter-version.h"

#include "clutter-enum-types.h"

#undef __CLUTTER_H_INSIDE__

#endif /* __CLUTTER_H__ */
