/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef KEYBOARDLAYOUT_H_
#define KEYBOARDLAYOUT_H_

#include <QtCore/QList>
#include <QtCore/QString>

class KeyboardLayout {
	QString name;
	QString abbreviation;
	QList<QString>* lowercaseChars;
	QList<QString>* uppercaseChars;
	QList<QString>* alternateLowercaseChars;
	QList<QString>* alternateUppercaseChars;
public:
	KeyboardLayout(QString name, QString abbreviation, QList<QString>* lowercaseChars,
			QList<QString>* uppercaseChars, QList<QString>* alternateLowercaseChars, QList<QString>* alternateUppercaseChars)
		: name(name), abbreviation(abbreviation), lowercaseChars(lowercaseChars), uppercaseChars(uppercaseChars),
		  alternateLowercaseChars(alternateLowercaseChars), alternateUppercaseChars(alternateUppercaseChars) {};
	virtual ~KeyboardLayout();
	static QList<KeyboardLayout*>* loadFromConfig();
	friend class VirtualKeyboard;
	friend class KeyboardLayoutMenuElement;
};

#endif /* KEYBOARDLAYOUT_H_ */
