/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef SEARCHBAR_H_
#define SEARCHBAR_H_

#include "../gl.h"
#include <QtCore/QString>
#include <QtCore/QList>

class SearchBar {
	GLuint texture, mask;
	QString inputValue;
	int cursorScreen; // Cursor position on screen (in pixels)
	int cursorInput; // Cursor position in input string (in chars)
	int selectionStart;
	int selectionCount;
	int historyIndex;
	QList<QString> history;
	long lastChange;
	void recomputeScreenCursor();
public:
	SearchBar();
	void render();
	int handleMouse();
	void cursorLeft();
	void cursorRight();
	void addChars(QString chars);
	void removeChar();
	bool isActive();
	QString getValue();
	virtual ~SearchBar();
};

#endif /* SEARCHBAR_H_ */
