/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef TEXTSURFACEMANAGER_H_
#define TEXTSURFACEMANAGER_H_

#include "../main.h"
#include <QtCore/QHash>
#include <SDL/SDL_ttf.h>


typedef struct {
	SDL_Surface* surface;
	GLuint texture;
	int width;
	int height;
} TextEntry;

class TextSurfaceManager {
private:
	QHash<int, TTF_Font*> fonts;
	QHash<QString, TextEntry*> textEntries;
	QString createKey(int fontSize, QString text);
	TextEntry* createEntry(int fontSize, QString text);
	TTF_Font* getFont(int fontSize);
public:
	TextSurfaceManager();
	virtual ~TextSurfaceManager();
	int getTextWidth(int fontSize, QString text);
	int getTextHeight(int fontSize, QString text);
	GLfloat** getTexCoords(TextEntry* textEntry);
	GLfloat** getTexCoordsLandscape(TextEntry* textEntry);
	TextEntry* getTextEntry(int fontSize, QString text);
	void deleteUnusedTextures();
	static TextSurfaceManager* instance();
};

#endif /* TEXTSURFACEMANAGER_H_ */
